/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Strings;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.EnumMode;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.Mode;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.NumericMode;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;

public class AmaltheaValidations {
    private static final String DIAGNOSTIC_SOURCE = "org.eclipse.app4mc.amalthea.model";
    private static int NO_INDEX = -1;

    public static boolean validateInvariants(MinAvgMaxStatistic obj, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid;
        boolean bl = isValid = (float)obj.getMin() <= obj.getAvg() && obj.getAvg() <= (float)obj.getMax();
        if (!isValid) {
            AmaltheaValidations.addError(obj, "MinAvgMaxStatistic: constraint min <= avg <= max violated", diagnostics);
        }
        return isValid;
    }

    public static boolean validateInvariants(IReferable obj, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid;
        boolean bl = isValid = !Strings.isNullOrEmpty((String)obj.getName());
        if (!isValid) {
            AmaltheaValidations.addError(obj, String.valueOf(obj.eClass().getName()) + ": missing name", diagnostics);
        }
        return isValid;
    }

    public static boolean validateInvariants(ModeLabel obj, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return AmaltheaValidations.checkModeAndValue(obj, obj.getMode(), obj.getInitialValue(), diagnostics);
    }

    public static boolean validateInvariants(ModeValue obj, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ModeLabel modeLabel = obj.getLabel();
        if (modeLabel == null) {
            AmaltheaValidations.addError(obj, String.valueOf(obj.eClass().getName()) + ": missing mode label", diagnostics);
            return false;
        }
        return AmaltheaValidations.checkModeAndValue(obj, modeLabel.getMode(), obj.getValue(), diagnostics);
    }

    public static boolean validateInvariants(ModeLabelAccess obj, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ModeLabel modeLabel = obj.getData();
        if (modeLabel == null) {
            AmaltheaValidations.addError(obj, String.valueOf(obj.eClass().getName()) + ": missing mode label", diagnostics);
            return false;
        }
        if (obj.getAccess() == ModeLabelAccessEnum.SET) {
            return AmaltheaValidations.checkModeAndValue(obj, modeLabel.getMode(), obj.getValue(), diagnostics);
        }
        return true;
    }

    private static boolean checkModeAndValue(EObject obj, Mode mode, String value, DiagnosticChain diagnostics) {
        if (mode == null) {
            AmaltheaValidations.addWarning(obj, String.valueOf(obj.eClass().getName()) + ": unknown value type (mode)", diagnostics);
            return false;
        }
        if (value == null) {
            AmaltheaValidations.addError(obj, String.valueOf(obj.eClass().getName()) + ": missing value", diagnostics);
            return false;
        }
        String trimmedValue = value.trim();
        if (mode instanceof EnumMode && ((EnumMode)mode).getLiteral(trimmedValue) == null) {
            AmaltheaValidations.addError(obj, String.valueOf(obj.eClass().getName()) + " (EnumMode): value does not match a literal name", diagnostics);
            return false;
        }
        if (mode instanceof NumericMode && !trimmedValue.matches("-?\\d+")) {
            AmaltheaValidations.addError(obj, String.valueOf(obj.eClass().getName()) + " (NumericMode): value is not an integer", diagnostics);
            return false;
        }
        return true;
    }

    private static void addInfo(EObject object, String message, DiagnosticChain diagnostics) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)AmaltheaValidations.createIssue(1, NO_INDEX, object, message));
        }
    }

    private static void addWarning(EObject object, String message, DiagnosticChain diagnostics) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)AmaltheaValidations.createIssue(2, NO_INDEX, object, message));
        }
    }

    private static void addError(EObject object, String message, DiagnosticChain diagnostics) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)AmaltheaValidations.createIssue(4, NO_INDEX, object, message));
        }
    }

    private static BasicDiagnostic createIssue(int severity, int code, EObject object, String message) {
        return new BasicDiagnostic(severity, DIAGNOSTIC_SOURCE, code, message, new Object[]{object});
    }
}

