/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.DiscreteValueConstant;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;

@Deprecated
public class InstructionsUtil {
    public static final String INSTRUCTIONS_CATEGORY_NAME = "Instructions";

    public static HwFeatureCategory getOrCreateInstructionsCategory(Amalthea model) {
        HWModel hwModel = ModelUtil.getOrCreateHwModel(model);
        for (HwFeatureCategory category : hwModel.getFeatureCategories()) {
            if (category.getName() == null || !category.getName().equals(INSTRUCTIONS_CATEGORY_NAME)) continue;
            return category;
        }
        HwFeatureCategory newCategory = AmaltheaFactory.eINSTANCE.createHwFeatureCategory();
        newCategory.setName(INSTRUCTIONS_CATEGORY_NAME);
        hwModel.getFeatureCategories().add((Object)newCategory);
        return newCategory;
    }

    public static ExecutionNeed createExecutionNeedConstant(long instructions) {
        return InstructionsUtil.createExecutionNeed(INSTRUCTIONS_CATEGORY_NAME, instructions);
    }

    public static IDiscreteValueDeviation getNeed(ExecutionNeed execNeed) {
        return (IDiscreteValueDeviation)execNeed.getNeeds().get((Object)INSTRUCTIONS_CATEGORY_NAME);
    }

    public static long getNeedConstant(ExecutionNeed execNeed) {
        return InstructionsUtil.getNeedConstant(execNeed, INSTRUCTIONS_CATEGORY_NAME);
    }

    public static IDiscreteValueDeviation getNeedDeviation(ExecutionNeed execNeed) {
        return InstructionsUtil.getNeedDeviation(execNeed, INSTRUCTIONS_CATEGORY_NAME);
    }

    public static double getIPC(Amalthea model, ProcessingUnit pu) {
        List<Double> values = InstructionsUtil.getFeatureValuesOfCategory(pu.getDefinition(), InstructionsUtil.getOrCreateInstructionsCategory(model));
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return 1.0;
    }

    private static ExecutionNeed createExecutionNeed(String category, long value) {
        DiscreteValueConstant dev = AmaltheaFactory.eINSTANCE.createDiscreteValueConstant();
        dev.setValue(value);
        ExecutionNeed execNeed = AmaltheaFactory.eINSTANCE.createExecutionNeed();
        execNeed.getNeeds().put((Object)category, (Object)dev);
        return execNeed;
    }

    private static long getNeedConstant(ExecutionNeed execNeed, String category) {
        if (execNeed == null || category == null) {
            return 0L;
        }
        IDiscreteValueDeviation dev = (IDiscreteValueDeviation)execNeed.getNeeds().get((Object)category);
        if (dev instanceof DiscreteValueConstant) {
            return ((DiscreteValueConstant)dev).getValue();
        }
        return 0L;
    }

    private static IDiscreteValueDeviation getNeedDeviation(ExecutionNeed execNeed, String category) {
        if (execNeed == null || category == null) {
            return null;
        }
        return (IDiscreteValueDeviation)execNeed.getNeeds().get((Object)category);
    }

    public static List<HwFeature> getFeaturesOfCategory(ProcessingUnitDefinition puDefinition, HwFeatureCategory category) {
        if (puDefinition == null || category == null) {
            return Collections.emptyList();
        }
        return puDefinition.getFeatures().stream().filter(i -> i.getContainingCategory() == category).collect(Collectors.toList());
    }

    public static List<Double> getFeatureValuesOfCategory(ProcessingUnitDefinition puDefinition, HwFeatureCategory category) {
        if (puDefinition == null || category == null) {
            return Collections.emptyList();
        }
        return puDefinition.getFeatures().stream().filter(i -> i.getContainingCategory() == category).map(i -> i.getValue()).collect(Collectors.toList());
    }
}

