/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Counter;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.EnforcedMigration;
import org.eclipse.app4mc.amalthea.model.EventMask;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.OsEvent;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.ServerCall;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleActivation;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SWModelValidatorImpl
extends AbstractValidatorImpl {
    public SWModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public SWModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkLabelSize(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Label label;
            DataSize size;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Label) || (size = (label = (Label)elem).getSize()) == null) continue;
            BigInteger value = size.getValue();
            if (value == null) {
                this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractMemoryElement_Size(), new Object[0]);
            } else if (value.compareTo(BigInteger.ZERO) <= 0) {
                this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractMemoryElement_Size(), new Object[0]);
            }
            DataSizeUnit unit = size.getUnit();
            if (unit == null) {
                this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractMemoryElement_Size(), new Object[0]);
                continue;
            }
            if (DataSizeUnit._UNDEFINED_ != unit) continue;
            this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractMemoryElement_Size(), new Object[0]);
        }
    }

    public void checkRunnableReferenceOfTaskRunnableCall(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<TaskRunnableCall> runnableCalls = new HashSet<TaskRunnableCall>();
        HashSet<Runnable> runnables = new HashSet<Runnable>();
        while (amaIter.hasNext()) {
            SWModel swModel;
            EList runnableList;
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof TaskRunnableCall) {
                TaskRunnableCall runnableCall = (TaskRunnableCall)elem;
                runnableCalls.add(runnableCall);
                continue;
            }
            if (!(elem instanceof SWModel) || (runnableList = (swModel = (SWModel)elem).getRunnables()) == null) continue;
            for (Runnable runnable : runnableList) {
                if (runnable == null) continue;
                runnables.add(runnable);
            }
        }
        for (TaskRunnableCall runnableCall : runnableCalls) {
            Runnable runnable;
            if (runnableCall == null || (runnable = runnableCall.getRunnable()) != null && runnables.contains(runnable)) continue;
            this.issueCreator.issue((EObject)runnableCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskRunnableCall_Runnable(), new Object[0]);
        }
    }

    public void checkRunnableReferenceOfRunnableCall(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashMap<RunnableCall, Runnable> call2Runnable = new HashMap<RunnableCall, Runnable>();
        HashSet<RunnableCall> runnableCalls = new HashSet<RunnableCall>();
        HashSet<Runnable> runnables = new HashSet<Runnable>();
        while (amaIter.hasNext()) {
            SWModel swModel;
            EList runnableList;
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof Runnable) {
                Runnable runnable = (Runnable)elem;
                for (RunnableItem runnableItem : runnable.getRunnableItems()) {
                    if (!(runnableItem instanceof RunnableCall)) continue;
                    RunnableCall runnableCall = (RunnableCall)runnableItem;
                    call2Runnable.put(runnableCall, runnable);
                    if (runnableCall == null) continue;
                    runnableCalls.add(runnableCall);
                }
                continue;
            }
            if (!(elem instanceof SWModel) || (runnableList = (swModel = (SWModel)elem).getRunnables()) == null) continue;
            for (Runnable runnable : runnableList) {
                if (runnable == null) continue;
                runnables.add(runnable);
            }
        }
        for (RunnableCall runnableCall : runnableCalls) {
            if (runnableCall == null) continue;
            Runnable calledRunnable = runnableCall.getRunnable();
            Runnable callingRunnable = (Runnable)call2Runnable.get(runnableCall);
            if (calledRunnable != null && runnables.contains(calledRunnable) && !calledRunnable.equals(callingRunnable)) continue;
            this.issueCreator.issue((EObject)runnableCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableCall_Runnable(), new Object[0]);
        }
    }

    public void checkOsEventReferenceOfEventMask(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<OsEvent> events = new HashSet<OsEvent>();
        HashSet<EventMask> eventMasks = new HashSet<EventMask>();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof SWModel) {
                SWModel model = (SWModel)elem;
                for (OsEvent event : model.getEvents()) {
                    if (event == null) continue;
                    events.add(event);
                }
                continue;
            }
            if (!(elem instanceof EventMask)) continue;
            EventMask eventMask = (EventMask)elem;
            eventMasks.add(eventMask);
        }
        for (EventMask eventMask : eventMasks) {
            if (eventMask == null) continue;
            if (eventMask.getEvents().isEmpty()) {
                this.issueCreator.issue((EObject)eventMask, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventMask_Events(), new Object[0]);
                continue;
            }
            for (OsEvent event : eventMask.getEvents()) {
                if (event != null && events.contains(event)) continue;
                this.issueCreator.issue((EObject)eventMask, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventMask_Events(), new Object[0]);
            }
        }
    }

    public void checkEventMaskEvents(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<OsEvent> sets = new HashSet<OsEvent>();
        HashSet<OsEvent> waits = new HashSet<OsEvent>();
        while (amaIter.hasNext()) {
            EventMask eventMask;
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof SetEvent) {
                SetEvent set = (SetEvent)elem;
                eventMask = set.getEventMask();
                for (OsEvent event : eventMask.getEvents()) {
                    if (event == null) continue;
                    sets.add(event);
                }
                continue;
            }
            if (!(elem instanceof WaitEvent)) continue;
            WaitEvent wait = (WaitEvent)elem;
            eventMask = wait.getEventMask();
            for (OsEvent event : eventMask.getEvents()) {
                if (event == null) continue;
                waits.add(event);
            }
        }
        HashSet disjoint = new HashSet(waits);
        disjoint.removeAll(sets);
        for (OsEvent event : disjoint) {
            if (event == null) continue;
            this.issueCreator.issue((EObject)event, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSWModel_Events(), new Object[]{event.getName()});
        }
    }

    public void checkModeSwitchValueProvider(Amalthea amalthea) {
    }

    public void checkModeSwitchEntryValue1(Amalthea amalthea) {
    }

    public void checkModeSwitchEntryValue2(Amalthea amalthea) {
    }

    public void checkModeLabelMode(Amalthea amalthea) {
    }

    public void checkModeLabelInitialValue(Amalthea amalthea) {
    }

    public void checkCounterOffset(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Counter counter;
            long offset;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Counter) || 0L < (offset = (counter = (Counter)elem).getOffset())) continue;
            this.issueCreator.issue((EObject)counter, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCounter_Offset(), new Object[0]);
        }
    }

    public void checkServerCallServerRunnable(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<Runnable> runnables = new HashSet<Runnable>();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Runnable)) continue;
            Runnable runnable = (Runnable)elem;
            runnables.add(runnable);
        }
        for (Runnable runnable : runnables) {
            for (RunnableItem item : runnable.getRunnableItems()) {
                if (!(item instanceof ServerCall)) continue;
                ServerCall serverCall = (ServerCall)item;
                Runnable serverRunnable = serverCall.getServerRunnable();
                if (serverRunnable == null) {
                    this.issueCreator.issue((EObject)serverCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getServerCall_ServerRunnable(), new Object[0]);
                    continue;
                }
                if (!runnables.contains(serverRunnable)) {
                    this.issueCreator.issue((EObject)serverCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getServerCall_ServerRunnable(), new Object[0]);
                    continue;
                }
                if (!serverRunnable.equals(runnable)) continue;
                this.issueCreator.issue((EObject)serverCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getServerCall_ServerRunnable(), new Object[0]);
            }
        }
    }

    public void checkEnforcedMigrationResourceOwner(Amalthea amalthea) {
        HashSet<EnforcedMigration> enforcedMigrations = new HashSet<EnforcedMigration>();
        OperatingSystem os = null;
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof EnforcedMigration) {
                EnforcedMigration enforcedMigration = (EnforcedMigration)elem;
                enforcedMigrations.add(enforcedMigration);
                continue;
            }
            if (!(elem instanceof OperatingSystem)) continue;
            os = (OperatingSystem)elem;
        }
        for (EnforcedMigration enforcedMigration : enforcedMigrations) {
            boolean found = false;
            Scheduler scheduler = enforcedMigration.getResourceOwner();
            if (os != null) {
                for (TaskScheduler taskScheduler : os.getTaskSchedulers()) {
                    if (!taskScheduler.equals(scheduler)) continue;
                    found = true;
                }
            }
            if (found) continue;
            this.issueCreator.issue((EObject)enforcedMigration, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEnforcedMigration_ResourceOwner(), new Object[0]);
        }
    }

    public void checkRunnableDeadlineUnsigned(Amalthea amalthea) {
    }

    public void checkPeriodicActivationMinUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicActivation periodicActivation;
            Time min;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicActivation) || (min = (periodicActivation = (PeriodicActivation)elem).getMin()) == null || (value = min.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)min, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicActivation_Min(), new Object[]{value});
        }
    }

    public void checkPeriodicActivationMaxUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicActivation periodicActivation;
            Time max;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicActivation) || (max = (periodicActivation = (PeriodicActivation)elem).getMax()) == null || (value = max.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)max, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicActivation_Max(), new Object[]{value});
        }
    }

    public void checkPeriodicActivationOffsetUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicActivation periodicActivation;
            Time offset;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicActivation) || (offset = (periodicActivation = (PeriodicActivation)elem).getOffset()) == null || (value = offset.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicActivation_Offset(), new Object[]{value});
        }
    }

    public void checkSingleActivationMinUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            SingleActivation singleActivation;
            Time min;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof SingleActivation) || (min = (singleActivation = (SingleActivation)elem).getMin()) == null || (value = min.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)min, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSingleActivation_Min(), new Object[]{value});
        }
    }

    public void checkSingleActivationMaxUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            SingleActivation singleActivation;
            Time max;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof SingleActivation) || (max = (singleActivation = (SingleActivation)elem).getMax()) == null || (value = max.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)max, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSingleActivation_Max(), new Object[]{value});
        }
    }

    public void checkModeLabelAccessModeEqual(Amalthea amalthea) {
    }

    public void checkModeLiteralMode(Amalthea amalthea) {
    }
}

