/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.validation.core.IValidation;
import org.eclipse.app4mc.validation.core.Result;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AmaltheaValidation
implements IValidation {
    protected static AmaltheaPackage ePackage = AmaltheaPackage.eINSTANCE;

    public EPackage getEPackage() {
        return ePackage;
    }

    protected String name(INamed object) {
        if (object == null) {
            return "?";
        }
        if (Strings.isNullOrEmpty((String)object.getName())) {
            return "?";
        }
        return "\"" + object.getName() + "\"";
    }

    protected String longName(IReferable object) {
        if (object == null) {
            return "?";
        }
        String prefix = object.getNamePrefix();
        if (prefix == null || prefix.isEmpty()) {
            return this.name((INamed)object);
        }
        return "\"" + prefix + "/" + object.getName() + "\"";
    }

    protected String typeInfo(EObject object) {
        if (object == null) {
            return "?";
        }
        String type = object.eClass().getName();
        String typeWithBlanks = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)type), (char)' ');
        return typeWithBlanks;
    }

    protected String objectInfo(EObject object) {
        if (object == null) {
            return "?";
        }
        String s1 = this.typeInfo(object);
        String s2 = object instanceof INamed ? " " + this.name((INamed)object) : "";
        return String.valueOf(s1) + s2;
    }

    protected String containerInfo(EObject object) {
        if (object == null) {
            return "";
        }
        return " ( in " + this.objectInfo(object.eContainer()) + " )";
    }

    protected Object attributeValue(EObject object, String attribName) {
        if (object == null || attribName == null) {
            return null;
        }
        EStructuralFeature feature = object.eClass().getEStructuralFeature(attribName);
        if (feature == null) {
            return null;
        }
        return object.eGet(feature);
    }

    protected void addIssue(List<Result> results, EObject object, String message) {
        results.add(new Result(message, object));
    }
}

