/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.hardware;

import java.util.Collections;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwPathElement;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.MemoryDefinition;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.validations.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.Result;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="AM-HW-AccessPath")
public class AmHwAccessPath
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getHwAccessPath();
    }

    public void validate(EObject object, List<Result> results) {
        if (object instanceof HwAccessPath) {
            EList pathElements;
            HwAccessPath path = (HwAccessPath)object;
            boolean performRangeCheck = true;
            Memory memory = null;
            MemoryDefinition memoryDef = null;
            long addressRange = path.getEndAddress() - path.getStartAddress();
            long requiredSize = path.getMemOffset() + addressRange;
            if (addressRange < 0L) {
                this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": Start address > End address");
                performRangeCheck = false;
            }
            if (path.getDestination() instanceof Memory) {
                memory = (Memory)path.getDestination();
                memoryDef = memory.getDefinition();
                if (memoryDef == null) {
                    this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": Destination (Memory) size is undefined");
                    performRangeCheck = false;
                }
            } else {
                performRangeCheck = false;
            }
            if (performRangeCheck && requiredSize > memoryDef.getSize().getNumberBytes()) {
                this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": Address range > Memory size");
            }
            if ((pathElements = path.getPathElements()).isEmpty()) {
                return;
            }
            ProcessingUnit source = path.getSource();
            HwDestination destination = path.getDestination();
            HwPathElement first = (HwPathElement)pathElements.get(0);
            HwPathElement last = (HwPathElement)pathElements.get(pathElements.size() - 1);
            if (first instanceof HwConnection) {
                if (Collections.disjoint(source.getPorts(), first.getPorts())) {
                    this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": No common port at the beginning of the path");
                }
            } else {
                this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": First path element must be a connection");
            }
            if (last instanceof HwConnection) {
                if (destination == null) {
                    this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": Destination is undefined");
                } else if (Collections.disjoint(destination.getPorts(), last.getPorts())) {
                    this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": No common port at the end of the path");
                }
            } else {
                this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": Last path element must be a connection");
            }
            if (pathElements.size() < 2) {
                return;
            }
            int i = 0;
            while (i < pathElements.size() - 1) {
                HwPathElement item1 = (HwPathElement)pathElements.get(i);
                HwPathElement item2 = (HwPathElement)pathElements.get(i + 1);
                if (Collections.disjoint(item1.getPorts(), item2.getPorts())) {
                    this.addIssue(results, (EObject)path, "HW Access Path " + this.name((INamed)path) + ": No common port between element[" + i + "] and element[" + (i + 1) + "]");
                }
                ++i;
            }
        }
    }
}

