/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.hardware;

import java.util.HashMap;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwDefinition;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.validations.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.Result;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="AM-HW-Definition")
public class AmHwDefinition
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getHwDefinition();
    }

    public void validate(EObject object, List<Result> results) {
        HwDefinition definition;
        if (object instanceof HwDefinition && (definition = (HwDefinition)object) instanceof ProcessingUnitDefinition) {
            ProcessingUnitDefinition puDef = (ProcessingUnitDefinition)definition;
            HashMap<HwFeatureCategory, HwFeature> visitedCategories = new HashMap<HwFeatureCategory, HwFeature>();
            for (HwFeature feature : puDef.getFeatures()) {
                HwFeatureCategory category = feature.getContainingCategory();
                if (visitedCategories.containsKey(category)) {
                    HwFeature firstFeature = visitedCategories.put(category, null);
                    if (firstFeature != null) {
                        this.addIssue(results, (EObject)definition, "HW Definition " + this.name((INamed)definition) + ": Reference to multiple features of one category - " + category.getName() + "::" + firstFeature.getName());
                    }
                    this.addIssue(results, (EObject)definition, "HW Definition " + this.name((INamed)definition) + ": Reference to multiple features of one category - " + category.getName() + "::" + feature.getName());
                    continue;
                }
                visitedCategories.put(category, feature);
            }
        }
    }
}

