/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters081.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils_080_081;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class StimuliConverter
extends AbstractConverter {
    public StimuliConverter() {
        this.helper = HelperUtils_080_081.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.0 to 0.8.1  : Executing Stimuli converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateAllModeValueListEntryElements(rootElement);
        this.updateAllStimulusElements(rootElement);
        this.updateCustomPropertiesForStimulus(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateCustomPropertiesForStimulus(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//customProperties/value[@value]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//customProperties/value/value");
        xpathBuffer.append("|");
        xpathBuffer.append(".//customProperties//values[@value]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//customProperties//values/value");
        HashMap<String, String> namesMap = new HashMap<String, String>();
        namesMap.put("ArrivalCurve", "ArrivalCurveStimulus");
        namesMap.put("InterProcess", "InterProcessStimulus");
        namesMap.put("Periodic", "PeriodicStimulus");
        namesMap.put("PeriodicEvent", "VariableRateStimulus");
        namesMap.put("Single", "SingleStimulus");
        namesMap.put("Sporadic", "SporadicStimulus");
        namesMap.put("Synthetic", "SyntheticStimulus");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element element : elements) {
            String newValue;
            String stimulusName;
            int indexOfEquals;
            String value;
            Attribute typeAttribute = element.getAttribute("type", this.helper.getGenericNS("xsi"));
            Attribute valueAttribute = element.getAttribute("value");
            Attribute hrefAttribute = element.getAttribute("href");
            if (typeAttribute != null && valueAttribute != null) {
                value = valueAttribute.getValue();
                indexOfEquals = value.indexOf("=");
                if (indexOfEquals == -1 || !namesMap.containsKey(stimulusName = value.substring(indexOfEquals + 1, value.length()))) continue;
                newValue = String.valueOf(value.substring(0, indexOfEquals + 1)) + (String)namesMap.get(stimulusName);
                valueAttribute.setValue(newValue);
                continue;
            }
            if (valueAttribute != null || hrefAttribute == null || typeAttribute == null) continue;
            this.updateStimulusTypeAttribute(element);
            value = hrefAttribute.getValue();
            indexOfEquals = value.indexOf("=");
            if (indexOfEquals == -1 || !namesMap.containsKey(stimulusName = value.substring(indexOfEquals + 1, value.length()))) continue;
            newValue = String.valueOf(value.substring(0, indexOfEquals + 1)) + (String)namesMap.get(stimulusName);
            hrefAttribute.setValue(newValue);
        }
    }

    private void updateAllStimulusElements(Element rootElement) {
        this.updateAllStimulusElementsDefinition(rootElement);
        this.updateAllStimulusElementsReferences(rootElement);
    }

    private void updateAllStimulusElementsReferences(Element rootElement) {
        HashMap<String, String> old_new_StimulusNamesMap = new HashMap<String, String>();
        old_new_StimulusNamesMap.put("ArrivalCurve", "ArrivalCurveStimulus");
        old_new_StimulusNamesMap.put("InterProcess", "InterProcessStimulus");
        old_new_StimulusNamesMap.put("Periodic", "PeriodicStimulus");
        old_new_StimulusNamesMap.put("PeriodicEvent", "VariableRateStimulus");
        old_new_StimulusNamesMap.put("Single", "SingleStimulus");
        old_new_StimulusNamesMap.put("Sporadic", "SporadicStimulus");
        old_new_StimulusNamesMap.put("Synthetic", "SyntheticStimulus");
        StringBuffer stimulusEventBuffer = new StringBuffer();
        stimulusEventBuffer.append("./eventModel/events[@xsi:type=\"am:StimulusEvent\"]");
        this.updateStimulusReferences(rootElement, old_new_StimulusNamesMap, stimulusEventBuffer, "entity", false);
        StringBuffer processBuffer = new StringBuffer();
        processBuffer.append("./swModel/tasks");
        processBuffer.append("|");
        processBuffer.append("./swModel/isrs");
        this.updateStimulusReferences(rootElement, old_new_StimulusNamesMap, processBuffer, "stimuli", false);
        StringBuffer interProcessActivationBuffer = new StringBuffer();
        interProcessActivationBuffer.append("./swModel/tasks//calls[@xsi:type=\"am:InterProcessActivation\"]");
        interProcessActivationBuffer.append("|");
        interProcessActivationBuffer.append("./swModel/isrs//calls[@xsi:type=\"am:InterProcessActivation\"]");
        this.updateStimulusReferences(rootElement, old_new_StimulusNamesMap, interProcessActivationBuffer, "stimulus", true);
    }

    private void updateStimulusReferences(Element rootElement, Map<String, String> old_new_StimulusNamesMap, StringBuffer stimulusEventBuffer, String variableName, boolean isInterProcessActivation) {
        List elements = this.helper.getXpathResult(rootElement, stimulusEventBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element targetElement : elements) {
            String typeValue;
            Attribute typeAttribute;
            Attribute attribute = targetElement.getAttribute(variableName);
            if (attribute != null) {
                StringBuffer updatedValueBuffer = new StringBuffer();
                StringTokenizer stk = new StringTokenizer(attribute.getValue());
                while (stk.hasMoreTokens()) {
                    String nextToken = stk.nextToken();
                    updatedValueBuffer.append(String.valueOf(this.getUpdatedStimulusReference(nextToken, old_new_StimulusNamesMap, isInterProcessActivation)) + " ");
                }
                String trimmedValue = updatedValueBuffer.toString().trim();
                if (trimmedValue.length() != 0) {
                    attribute.setValue(trimmedValue);
                } else {
                    attribute.detach();
                }
            }
            List children = this.helper.getXpathResult(targetElement, "./" + variableName, Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
            for (Element element : children) {
                String updatedValue;
                String value;
                String attributeValue;
                if (isInterProcessActivation && (attributeValue = element.getAttributeValue("type", this.helper.getGenericNS("xsi"))) != null && !attributeValue.equals("InterProcess")) {
                    element.detach();
                    continue;
                }
                this.updateStimulusTypeAttribute(element);
                Attribute hrefAttribute = element.getAttribute("href");
                if (hrefAttribute == null || (value = hrefAttribute.getValue()).equals(updatedValue = this.getUpdatedStimulusReference(value, old_new_StimulusNamesMap, isInterProcessActivation))) continue;
                hrefAttribute.setValue(updatedValue);
            }
            if (!isInterProcessActivation || (typeAttribute = targetElement.getAttribute("type", this.helper.getGenericNS("xsi"))) == null || !(typeValue = typeAttribute.getValue()).equals("am:InterProcessActivation")) continue;
            typeAttribute.setValue("am:InterProcessTrigger");
        }
    }

    private String getUpdatedStimulusReference(String token, Map<String, String> old_new_StimulusNamesMap, boolean isInterProcessActivation) {
        int indexOfEquals = token.indexOf("=");
        if (indexOfEquals != -1) {
            String stimulusType = token.substring(indexOfEquals + 1, token.length());
            if (isInterProcessActivation && !stimulusType.equals("InterProcess")) {
                return "";
            }
            if (old_new_StimulusNamesMap.containsKey(stimulusType)) {
                return String.valueOf(token.substring(0, indexOfEquals + 1)) + old_new_StimulusNamesMap.get(stimulusType);
            }
        }
        return token;
    }

    private void updateAllStimulusElementsDefinition(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./stimuliModel/stimuli");
        List stimulusElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element stimulusElement : stimulusElements) {
            this.updateStimulusTypeAttribute(stimulusElement);
        }
    }

    private void updateStimulusTypeAttribute(Element stimulusElement) {
        Attribute typeAttribute = stimulusElement.getAttribute("type", this.helper.getGenericNS("xsi"));
        if (typeAttribute != null) {
            String stimulusType = typeAttribute.getValue();
            if (stimulusType.equals("am:EventStimulus")) {
                this.updateEventStimulus(stimulusElement);
            } else if (stimulusType.equals("am:ArrivalCurve")) {
                typeAttribute.setValue("am:ArrivalCurveStimulus");
            } else if (stimulusType.equals("am:InterProcess")) {
                typeAttribute.setValue("am:InterProcessStimulus");
            } else if (stimulusType.equals("am:Periodic")) {
                typeAttribute.setValue("am:PeriodicStimulus");
            } else if (stimulusType.equals("am:PeriodicEvent")) {
                typeAttribute.setValue("am:VariableRateStimulus");
            } else if (stimulusType.equals("am:Single")) {
                typeAttribute.setValue("am:SingleStimulus");
            } else if (stimulusType.equals("am:Sporadic")) {
                typeAttribute.setValue("am:SporadicStimulus");
            } else if (stimulusType.equals("am:Synthetic")) {
                typeAttribute.setValue("am:SyntheticStimulus");
            }
        }
    }

    private void updateEventStimulus(Element stimulusElement) {
        List triggerElements;
        Attribute triggerAttribute = stimulusElement.getAttribute("trigger");
        if (triggerAttribute != null) {
            triggerAttribute.setName("triggeringEvents");
        }
        if ((triggerElements = stimulusElement.getChildren("trigger")) != null) {
            for (Element triggerElement : triggerElements) {
                triggerElement.setName("triggeringEvents");
            }
        }
    }

    private void updateAllModeValueListEntryElements(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./stimuliModel/stimuli/setModeValueList/entries");
        xpathBuffer.append("|");
        xpathBuffer.append("./stimuliModel/stimuli/enablingModeValueList/entries");
        xpathBuffer.append("|");
        xpathBuffer.append("./stimuliModel/stimuli/disablingModeValueList/entries");
        List modeValueListEntryElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element modeValueListEntry : modeValueListEntryElements) {
            modeValueListEntry.setAttribute("type", "am:ModeValue", this.helper.getGenericNS("xsi"));
        }
    }
}

