/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters093.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;

public class HwConverter
extends AbstractConverter {
    private File targetFile;

    public HwConverter() {
        this.helper = HelperUtils_092_093.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.2 to 0.9.3 : Executing Hw converter for model file : " + targetFile.getName()));
        this.caches = caches;
        this.fileName_documentsMap = fileName_documentsMap;
        this.targetFile = targetFile;
        Document root = fileName_documentsMap.get(this.targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_Latency(rootElement);
    }

    private void update_Latency(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./hwModel//accessLatency");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel//readLatency");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel//writeLatency");
        List latencyElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_093("am"), this.helper.getGenericNS("xsi")});
        for (Element latencyElement : latencyElements) {
            Attribute typeAttribute = latencyElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            if (typeAttribute == null) continue;
            String type = typeAttribute.getValue();
            if (type.equals("am:LatencyConstant")) {
                type = "am:DiscreteValueConstant";
                typeAttribute.setValue(type);
                Attribute cyclesAttribute = latencyElement.getAttribute("cycles");
                if (cyclesAttribute == null) continue;
                cyclesAttribute.setName("value");
                continue;
            }
            if (!type.equals("am:LatencyDeviation")) continue;
            String elementName = latencyElement.getName();
            Parent parentElement = latencyElement.getParent();
            int indexOf = parentElement.indexOf((Content)latencyElement);
            Element migratedElement = this.migrateDeviationElement_Containing_LongValue(latencyElement.getChild("cycles"), elementName, 1.0);
            parentElement.removeContent((Content)latencyElement);
            if (migratedElement == null) continue;
            parentElement.addContent(indexOf, (Content)migratedElement);
        }
    }
}

