/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters093.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class OsConverter
extends AbstractConverter {
    private File targetFile;

    public OsConverter() {
        this.helper = HelperUtils_092_093.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.2 to 0.9.3 : Executing Os converter for model file : " + targetFile.getName()));
        this.caches = caches;
        this.fileName_documentsMap = fileName_documentsMap;
        this.targetFile = targetFile;
        Document root = fileName_documentsMap.get(this.targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_OsOverhead_ref(rootElement);
        this.update_OsAPIInstructions_OsISRInstructions(rootElement);
    }

    private void update_OsOverhead_ref(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./osModel/operatingSystems");
        List operatingSystems = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_093("am"), this.helper.getGenericNS("xsi")});
        for (Element operatingSystemElement : operatingSystems) {
            String overHead_Element_Name = this.helper.getSingleElementNameFromAttributeOrChildeElement("overhead", operatingSystemElement);
            operatingSystemElement.removeAttribute("overhead");
            operatingSystemElement.removeChild("overhead");
            if (overHead_Element_Name == null) continue;
            Element osOverHeadRefElement = new Element("overhead");
            Attribute hrefAttribute = new Attribute("href", "amlt://#" + overHead_Element_Name + "?type=OsOverhead");
            osOverHeadRefElement.setAttribute(hrefAttribute);
            operatingSystemElement.addContent((Content)osOverHeadRefElement);
        }
    }

    private void update_OsAPIInstructions_OsISRInstructions(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSendMessage");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiTerminateTask");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSchedule");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiRequestResource");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiReleaseResource");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSetEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiWaitEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiClearEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiActivateTask");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiEnforcedMigration");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSuspendOsInterrupts");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiResumeOsInterrupts");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiRequestSpinlock");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiReleaseSpinlock");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSenderReceiverRead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSenderReceiverWrite");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSynchronousServerCallPoint");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiIocRead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiIocWrite");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory1Overhead/preExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory1Overhead/postExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory2Overhead/preExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory2Overhead/postExecutionOverhead");
        List osInstructionsSubElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_093("am"), this.helper.getGenericNS("xsi")});
        for (Element osInstructionsSubElement : osInstructionsSubElements) {
            Element deviationElement;
            String typeAttributeValue = osInstructionsSubElement.getAttributeValue("type", this.helper.getGenericNS("xsi"));
            String value = osInstructionsSubElement.getAttributeValue("value");
            osInstructionsSubElement.removeAttribute("type", this.helper.getGenericNS("xsi"));
            osInstructionsSubElement.removeAttribute("value");
            osInstructionsSubElement.removeChild("fetchStatistic");
            if (typeAttributeValue.equals("am:InstructionsConstant")) {
                Element defaultElement = new Element("default");
                defaultElement.setAttribute(new Attribute("type", "am:DiscreteValueConstant", this.helper.getGenericNS("xsi")));
                defaultElement.setAttribute("value", value != null ? value : "0");
                osInstructionsSubElement.addContent((Content)defaultElement);
                continue;
            }
            if (!typeAttributeValue.equals("am:InstructionsDeviation") || (deviationElement = osInstructionsSubElement.getChild("deviation")) == null) continue;
            Element migratedElement = this.migrateDeviationElement_Containing_LongValue(deviationElement, "default", 1.0);
            osInstructionsSubElement.removeContent((Content)deviationElement);
            if (migratedElement == null) continue;
            osInstructionsSubElement.addContent((Content)migratedElement);
        }
    }
}

