/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters095.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters095.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters095.utils.HelperUtils_094_095;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
extends AbstractConverter {
    public SwConverter() {
        this.helper = HelperUtils_094_095.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File file, Map<File, Document> map, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.4 to 0.9.5 : Executing Sw converter for model file : " + file.getName()));
        this.basicConvert(file, map, caches);
    }

    public void basicConvert(File file, Map<File, Document> map, List<ICache> caches) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.update_GraphEntries(rootElement);
        this.update_CallSequences(rootElement);
        this.update_RunnableItems(rootElement);
        this.update_RunnableModeSwitches(rootElement);
        this.update_RunnableProbabilitySwitches(rootElement);
    }

    private void update_GraphEntries(Element rootElement) {
        List entries = this.helper.getXpathResult(rootElement, "./swModel/tasks/callGraph/graphEntries", Element.class, new Namespace[]{this.helper.getNS_095("am"), this.helper.getGenericNS("xsi")});
        for (Element graphEntry : entries) {
            graphEntry.setName("items");
        }
    }

    private void update_CallSequences(Element rootElement) {
        List callSequences = this.helper.getXpathResult(rootElement, "./swModel/tasks//*[@xsi:type=\"am:CallSequence\"]", Element.class, new Namespace[]{this.helper.getNS_095("am"), this.helper.getGenericNS("xsi")});
        for (Element cs : callSequences) {
            cs.setAttribute("type", "am:Group", this.helper.getGenericNS("xsi"));
            String oldName = cs.getAttributeValue("name");
            if (oldName == null || oldName.isEmpty()) {
                cs.setAttribute("name", "CallSequence");
            }
            cs.setAttribute("ordered", "true");
            for (Element call : cs.getChildren()) {
                call.setName("items");
                String callType = call.getAttributeValue("type", this.helper.getGenericNS("xsi"));
                if (!callType.equals("am:TaskRunnableCall")) continue;
                call.setAttribute("type", "am:RunnableCall", this.helper.getGenericNS("xsi"));
            }
        }
    }

    private void update_RunnableItems(Element rootElement) {
        List runnables = this.helper.getXpathResult(rootElement, "./swModel/runnables", Element.class, new Namespace[]{this.helper.getNS_095("am"), this.helper.getGenericNS("xsi")});
        for (Element runnable : runnables) {
            Element callGraph = new Element("callGraph");
            runnable.addContent((Content)callGraph);
            ArrayList runnableItems = new ArrayList(runnable.getChildren("runnableItems"));
            for (Element item : runnableItems) {
                item.setName("items");
                item.detach();
                callGraph.addContent((Content)item);
            }
        }
    }

    private void update_RunnableModeSwitches(Element rootElement) {
        List switches = this.helper.getXpathResult(rootElement, "./swModel/runnables//*[@xsi:type=\"am:RunnableModeSwitch\"]", Element.class, new Namespace[]{this.helper.getNS_095("am"), this.helper.getGenericNS("xsi")});
        for (Element elem : switches) {
            elem.setAttribute("type", "am:ModeSwitch", this.helper.getGenericNS("xsi"));
        }
    }

    private void update_RunnableProbabilitySwitches(Element rootElement) {
        List switches = this.helper.getXpathResult(rootElement, "./swModel/runnables//*[@xsi:type=\"am:RunnableProbabilitySwitch\"]", Element.class, new Namespace[]{this.helper.getNS_095("am"), this.helper.getGenericNS("xsi")});
        for (Element elem : switches) {
            elem.setAttribute("type", "am:ProbabilitySwitch", this.helper.getGenericNS("xsi"));
        }
    }
}

