/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.utils;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelMigrationJob;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationSettings;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ModelMigrationDelegator {
    private MigrationSettings migrationSettings;
    private Logger logger;
    private FileAppender fileAppender;

    public ModelMigrationDelegator(MigrationSettings migrationSettings, Logger logger) {
        this.migrationSettings = migrationSettings;
        this.logger = logger;
        this.initializeFileAppender();
    }

    public ModelMigrationDelegator(MigrationSettings migrationSettings, Logger logger, FileAppender fileAppender) {
        this.migrationSettings = migrationSettings;
        this.logger = logger;
        this.fileAppender = fileAppender;
    }

    public void execute() {
        ModelMigrationJob migrationJob = new ModelMigrationJob("AMALTHEA Model Migration", this.migrationSettings);
        migrationJob.setUser(true);
        migrationJob.schedule();
        migrationJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                super.done(event);
                IStatus result = event.getResult();
                if (result.getCode() == 20) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = new Shell(Display.getDefault());
                            MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)event.getResult().getMessage());
                        }
                    });
                } else if (result.getCode() == 30) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = new Shell(Display.getDefault());
                            ErrorDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)event.getResult().getMessage(), (IStatus)event.getResult());
                        }
                    });
                } else if (result.equals(Status.OK_STATUS)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = new Shell(Display.getDefault());
                            MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA Model Migration", (String)"Model Migration successful !!");
                            try {
                                ModelMigrationDelegator.this.getMigrationSettings().getiProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                ModelMigrationDelegator.this.getLogger().error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                }
                if (ModelMigrationDelegator.this.getFileAppender() != null) {
                    ModelMigrationDelegator.this.getFileAppender().close();
                    ModelMigrationDelegator.this.getLogger().removeAppender((Appender)ModelMigrationDelegator.this.getFileAppender());
                }
            }
        });
    }

    public MigrationSettings getMigrationSettings() {
        return this.migrationSettings;
    }

    public FileAppender getFileAppender() {
        return this.fileAppender;
    }

    public void setFileAppender(FileAppender fileAppender) {
        this.fileAppender = fileAppender;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void initializeFileAppender() {
        if (this.fileAppender == null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
            String dateToStr = format.format(new Date());
            File modelMigrationLogFile = new File(this.getMigrationSettings().getOutputDirectoryLocation(), "ModelMigration__" + dateToStr + ".log");
            try {
                this.setFileAppender(new FileAppender((Layout)new PatternLayout("%d{yyyy-MM-dd_HH_mm_ss} - %-5p:  %m%n"), modelMigrationLogFile.getAbsolutePath(), false));
                this.getFileAppender().addFilter(new Filter(){

                    public int decide(LoggingEvent event) {
                        if (event.getLevel() == Level.TRACE) {
                            return -1;
                        }
                        return 1;
                    }
                });
                this.logger.addAppender((Appender)this.getFileAppender());
            }
            catch (IOException e1) {
                this.logger.error((Object)("Unable to add FileAppender for model migration logger" + modelMigrationLogFile.getAbsolutePath()), (Throwable)e1);
            }
        }
    }
}

