/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MemoryType implements Enumerator
{
    _UNDEFINED_(0, "_undefined_", "_undefined_"),
    DRAM(0, "DRAM", "DRAM"),
    SRAM(0, "SRAM", "SRAM"),
    FLASH(0, "FLASH", "FLASH"),
    PCM(0, "PCM", "PCM");

    public static final int _UNDEFINED__VALUE = 0;
    public static final int DRAM_VALUE = 0;
    public static final int SRAM_VALUE = 0;
    public static final int FLASH_VALUE = 0;
    public static final int PCM_VALUE = 0;
    private static final MemoryType[] VALUES_ARRAY;
    public static final List<MemoryType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MemoryType[]{_UNDEFINED_, DRAM, SRAM, FLASH, PCM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MemoryType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MemoryType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MemoryType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MemoryType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MemoryType get(int value) {
        switch (value) {
            case 0: {
                return _UNDEFINED_;
            }
        }
        return null;
    }

    private MemoryType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

