/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.LimitType;
import org.eclipse.app4mc.amalthea.model.ProcessRequirement;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableRequirement;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeMetric;
import org.eclipse.app4mc.amalthea.model.TimeRequirementLimit;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.emf.ecore.EObject;

public class ConstraintsUtil {
    public static Time getDeadline(AbstractProcess process) {
        return ConstraintsUtil.getDeadline(process, ConstraintsUtil.getConstraintsModel(process));
    }

    public static Time getDeadline(AbstractProcess process, ConstraintsModel constModel) {
        if (process == null || constModel == null) {
            return null;
        }
        List list = ConstraintsUtil.getDeadlineRequirements(process, constModel).stream().map(req -> ((TimeRequirementLimit)req.getLimit()).getLimitValue()).filter(Objects::nonNull).sorted(Time::compareTo).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (Time)list.get(0);
    }

    public static Time getDeadline(Runnable runnable) {
        return ConstraintsUtil.getDeadline(runnable, ConstraintsUtil.getConstraintsModel(runnable));
    }

    public static Time getDeadline(Runnable runnable, ConstraintsModel constModel) {
        if (runnable == null || constModel == null) {
            return null;
        }
        List list = ConstraintsUtil.getDeadlineRequirements(runnable, constModel).stream().map(req -> ((TimeRequirementLimit)req.getLimit()).getLimitValue()).filter(Objects::nonNull).sorted(Time::compareTo).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (Time)list.get(0);
    }

    public static void addNewDeadlineRequirement(ConstraintsModel container, AbstractProcess process, Time deadline) {
        if (container == null) {
            return;
        }
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        limit.setMetric(TimeMetric.RESPONSE_TIME);
        limit.setLimitType(LimitType.UPPER_LIMIT);
        limit.setLimitValue(deadline);
        ProcessRequirement req = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        req.setName("Process deadline");
        req.setProcess(process);
        req.setLimit(limit);
        container.getRequirements().add((Object)req);
    }

    public static void addNewDeadlineRequirement(ConstraintsModel container, Runnable runnable, Time deadline) {
        if (container == null) {
            return;
        }
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        limit.setMetric(TimeMetric.RESPONSE_TIME);
        limit.setLimitType(LimitType.UPPER_LIMIT);
        limit.setLimitValue(deadline);
        RunnableRequirement req = AmaltheaFactory.eINSTANCE.createRunnableRequirement();
        req.setName("Runnable deadline");
        req.setRunnable(runnable);
        req.setLimit(limit);
        container.getRequirements().add((Object)req);
    }

    public static void updateDeadlineRequirement(Task task, Time deadline) {
        ConstraintsUtil.updateDeadlineRequirement(task, deadline, ConstraintsUtil.getConstraintsModel(task));
    }

    public static void updateDeadlineRequirement(Task task, Time deadline, ConstraintsModel constModel) {
        List<ProcessRequirement> requirements = ConstraintsUtil.getDeadlineRequirements(task, constModel);
        if (requirements.isEmpty()) {
            ConstraintsUtil.addNewDeadlineRequirement(constModel, task, deadline);
        } else {
            ProcessRequirement first = requirements.remove(0);
            ((TimeRequirementLimit)first.getLimit()).setLimitValue(deadline);
            AmaltheaIndex.deleteAll(requirements);
        }
    }

    public static void updateDeadlineRequirement(Runnable runnable, Time deadline) {
        ConstraintsUtil.updateDeadlineRequirement(runnable, deadline, ConstraintsUtil.getConstraintsModel(runnable));
    }

    public static void updateDeadlineRequirement(Runnable runnable, Time deadline, ConstraintsModel constModel) {
        List<RunnableRequirement> requirements = ConstraintsUtil.getDeadlineRequirements(runnable, constModel);
        if (requirements.isEmpty()) {
            ConstraintsUtil.addNewDeadlineRequirement(constModel, runnable, deadline);
        } else {
            RunnableRequirement first = requirements.remove(0);
            ((TimeRequirementLimit)first.getLimit()).setLimitValue(deadline);
            AmaltheaIndex.deleteAll(requirements);
        }
    }

    public static List<RunnableRequirement> getDeadlineRequirements(Runnable runnable, ConstraintsModel constModel) {
        if (runnable == null || constModel == null) {
            return Collections.emptyList();
        }
        return constModel.getRequirements().stream().filter(req -> req.getLimit().getLimitType() == LimitType.UPPER_LIMIT && req instanceof RunnableRequirement && ((RunnableRequirement)req).getRunnable() == runnable && req.getLimit() instanceof TimeRequirementLimit && ((TimeRequirementLimit)req.getLimit()).getMetric() == TimeMetric.RESPONSE_TIME).map(req -> (RunnableRequirement)req).collect(Collectors.toList());
    }

    public static List<ProcessRequirement> getDeadlineRequirements(AbstractProcess process, ConstraintsModel constModel) {
        if (process == null || constModel == null) {
            return Collections.emptyList();
        }
        return constModel.getRequirements().stream().filter(req -> req.getLimit().getLimitType() == LimitType.UPPER_LIMIT && req instanceof ProcessRequirement && ((ProcessRequirement)req).getProcess() == process && req.getLimit() instanceof TimeRequirementLimit && ((TimeRequirementLimit)req.getLimit()).getMetric() == TimeMetric.RESPONSE_TIME).map(req -> (ProcessRequirement)req).collect(Collectors.toList());
    }

    private static ConstraintsModel getConstraintsModel(EObject object) {
        if (object == null) {
            return null;
        }
        Amalthea modelRoot = AmaltheaServices.getContainerOfType(object, Amalthea.class);
        if (modelRoot == null) {
            return null;
        }
        return ModelUtil.getOrCreateConstraintsModel(modelRoot);
    }
}

