/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.editor.ExtendedBasicTransactionalFormEditor;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.app4mc.validation.ui.ProfileDialog;
import org.eclipse.app4mc.validation.ui.ProfileDialogSettings;
import org.eclipse.app4mc.validation.ui.ValidationUIPlugin;
import org.eclipse.app4mc.validation.ui.util.ValidationMarkerHelper;
import org.eclipse.app4mc.validation.util.ValidationExecutor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ValidateAction
extends Action {
    private final ExtendedBasicTransactionalFormEditor editor;

    public ValidateAction(StructuredViewer viewer, ExtendedBasicTransactionalFormEditor editor) {
        super("Validate", 1);
        this.editor = editor;
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)ValidationUIPlugin.getPluginId(), (String)"/icons/full/obj16/test.png"));
        this.setToolTipText("Validate model");
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ProfileDialogSettings settings = new ProfileDialogSettings();
        settings.addAllRegisteredProfileClasses();
        IDialogSettings store = ValidationUIPlugin.getDefault().getDialogSettings();
        settings.loadFrom(store);
        ProfileDialog dialog = new ProfileDialog(window.getShell(), settings);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            List selectedProfiles = settings.dialogResults;
            if (selectedProfiles == null || selectedProfiles.isEmpty()) {
                return;
            }
            settings.saveTo(store);
            System.out.println("Selected profiles:");
            for (Class sc : selectedProfiles) {
                System.out.println("  - " + sc.getName());
            }
            System.out.println("Available processors: " + Runtime.getRuntime().availableProcessors());
            Object input = this.editor.getEditorInputObject();
            if (input == null) {
                return;
            }
            EObject tmpModel = null;
            if (input instanceof EObject) {
                tmpModel = (EObject)input;
            } else if (input instanceof Resource && ((Resource)input).getContents().size() > 0) {
                tmpModel = (EObject)((Resource)input).getContents().get(0);
            }
            if (tmpModel == null) {
                return;
            }
            final ValidationExecutor executor = new ValidationExecutor((Collection)selectedProfiles);
            final EObject model = tmpModel;
            Job job = new Job("Model Validation"){

                protected IStatus run(IProgressMonitor monitor) {
                    return executor.validate(model, monitor);
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK() && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
                        executor.dumpResultMap(null);
                        BasicDiagnostic diagnostics = new BasicDiagnostic();
                        for (ValidationDiagnostic diag : executor.getResults()) {
                            diagnostics.add((Diagnostic)diag);
                        }
                        ValidationMarkerHelper markerHelper = new ValidationMarkerHelper();
                        markerHelper.deleteMarkers((Object)model.eResource());
                        try {
                            markerHelper.createMarkers((Diagnostic)diagnostics);
                        }
                        catch (CoreException coreException) {}
                    }
                }
            });
            job.schedule();
        }
    }
}

