/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.basic;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Basic-ContinuousValueGaussDistribution-mean")
public class TABasicContinuousValueGaussDistribution
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getContinuousValueGaussDistribution();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof ContinuousValueGaussDistribution) {
            ContinuousValueGaussDistribution cvgd = (ContinuousValueGaussDistribution)eObject;
            INamed namedContainer = (INamed)AmaltheaServices.getContainerOfType((EObject)cvgd, INamed.class);
            double mean = cvgd.getMean();
            if (Double.isFinite(mean)) {
                Double upper;
                Double lower = cvgd.getLowerBound();
                if (lower != null && !lower.isNaN() && !lower.isInfinite() && Double.compare(lower, mean) > 0) {
                    this.addIssue(results, (EObject)cvgd, (EStructuralFeature)ePackage.getContinuousValueGaussDistribution_Mean(), String.valueOf(this.getEClassifier().getName()) + ": mean is less than the lower bound: (" + mean + " < " + lower + ", in " + this.objectInfo((EObject)namedContainer) + ")");
                }
                if ((upper = cvgd.getUpperBound()) != null && !upper.isNaN() && !upper.isInfinite() && Double.compare(upper, mean) < 0) {
                    this.addIssue(results, (EObject)cvgd, (EStructuralFeature)ePackage.getContinuousValueGaussDistribution_Mean(), String.valueOf(this.getEClassifier().getName()) + ": mean is greater than the upper bound: (" + mean + " > " + upper + ", in " + this.objectInfo((EObject)namedContainer) + ")");
                }
            }
        }
    }
}

