/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.basic;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Basic-DiscreteValueGaussDistribution-mean")
public class TABasicDiscreteValueGaussDistribution
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getDiscreteValueGaussDistribution();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof DiscreteValueGaussDistribution) {
            DiscreteValueGaussDistribution dvgd = (DiscreteValueGaussDistribution)eObject;
            INamed namedContainer = (INamed)AmaltheaServices.getContainerOfType((EObject)dvgd, INamed.class);
            double mean = dvgd.getMean();
            if (Double.isFinite(mean)) {
                Long upper;
                Long lower = dvgd.getLowerBound();
                if (lower != null && Double.compare(lower.longValue(), mean) > 0) {
                    this.addIssue(results, (EObject)dvgd, (EStructuralFeature)ePackage.getDiscreteValueGaussDistribution_Mean(), String.valueOf(this.getEClassifier().getName()) + ": mean is less than the lower bound: (" + mean + " < " + lower + ", in " + this.objectInfo((EObject)namedContainer) + ")");
                }
                if ((upper = dvgd.getUpperBound()) != null && Double.compare(upper.longValue(), mean) < 0) {
                    this.addIssue(results, (EObject)dvgd, (EStructuralFeature)ePackage.getDiscreteValueGaussDistribution_Mean(), String.valueOf(this.getEClassifier().getName()) + ": mean is greater than the upper bound: (" + mean + " > " + upper + ", in " + this.objectInfo((EObject)namedContainer) + ")");
                }
            }
        }
    }
}

