/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.mwe2.util;

import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ICallGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.Preemption;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.workflow.mwe2.AmaltheaWorkflow;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class AddSchedulePoints
extends AmaltheaWorkflow {
    public AddSchedulePoints() {
        this.log = Logger.getLogger((String)"AddSchedulePoints");
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        if (this.getAmaltheaModel(ctx).getSwModel() == null) {
            issues.addError((WorkflowComponent)this, "No proper SWModel available!", (Object)this.getModelSlot());
            return;
        }
        if (this.getAmaltheaModel(ctx).getSwModel().getTasks().isEmpty()) {
            issues.addWarning((WorkflowComponent)this, "No Tasks available to check!", (Object)this.getModelSlot());
            return;
        }
        this.log.info((Object)"Starting...");
        for (Task task : this.getAmaltheaModel(ctx).getSwModel().getTasks()) {
            if (task.getCallGraph() == null || !task.getPreemption().equals((Object)Preemption.COOPERATIVE)) continue;
            this.log.info((Object)("Adding schedule points to cooperative Task [" + task.getName() + "]"));
            EList calls = SoftwareUtil.collectCallGraphItems((ICallGraphItemContainer)task.getCallGraph(), null, RunnableCall.class);
            for (RunnableCall rc : calls) {
                EObject container = rc.eContainer();
                EStructuralFeature feature = rc.eContainingFeature();
                if (container == null || feature == null || !feature.isMany()) continue;
                EList list = (EList)container.eGet(feature);
                int index = list.indexOf((Object)rc);
                list.add(index + 1, (Object)AmaltheaFactory.eINSTANCE.createSchedulePoint());
            }
        }
        this.log.info((Object)"Finished.");
    }
}

