/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.tracing.converter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.math.BigInteger;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.app4mc.tracing.converter.Htf2OT1Mapping;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.AutosarOsType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.ClockType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.DocumentRoot;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventDescriptionType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventIdMappingType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventTypeEnum;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.OT1Factory;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.OT1Type1;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulingEntityElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulingEntityType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TimeBaseEnum;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TimeValueType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TraceEntryType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TracesType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.VersionType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.XmlTraceType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.impl.OT1FactoryImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class Htf2Ot1Converter {
    private final String KEY_TYPE_TABLE = "TypeTable";
    private final String KEY_TASK_EVENT = "TaskEventTable";
    private final String KEY_INTERRPUT_EVENT = "ISREventTable";
    private final String KEY_RUNNABLE_EVENT = "RunnableEventTable";
    private final String KEY_CODEBLOCK_EVENT = "CodeBlockEventTable";
    private final String KEY_SIGNAL_EVENT = "SignalEventTable";
    private final String KEY_SEMAPHORE_EVENT = "SemaphoreEventTable";
    private final String KEY_ENTITY_TABLE = "EntityTable";
    private final String KEY_ENTITY_TYPE_TABLE = "EntityTypeTable";
    private final String KEY_TRACEDATA = "Tracedata";
    private Map<String, String> headerContent;
    private Map<Integer, EntityType> typeTable;
    private Map<Integer, TaskEvent> taskEventTable;
    private Map<Integer, InterruptEvent> interruptEventTable;
    private Map<Integer, RunnableEvent> runnableEventTable;
    private Map<Integer, CodeBlockEvent> codeBlockEventTable;
    private Map<Integer, SignalEvent> signalEventTable;
    private Map<Integer, SemaphoreEvent> semaphoreEventTable;
    private Map<Integer, String> entityTable;
    private Map<Integer, EntityType> entityTypeTable;
    private final String PREFIX_KEY = "#";
    private final String PREFIX_TABLE = "#-";
    private final int NUM_HEX_DIGITS_PER_BYTE = 2;
    private final int HEX_RADIX = 16;
    private final OT1Factory ot1Factory = OT1FactoryImpl.init();
    private final Htf2OT1Mapping htf2OT1mapping = new Htf2OT1Mapping();
    private long uuid = 0L;
    private DocumentRoot ot1Model;

    Htf2Ot1Converter() {
        this.init();
    }

    private void init() {
        this.uuid = 0L;
        this.headerContent = new HashMap<String, String>();
        this.entityTable = new HashMap<Integer, String>();
        this.entityTypeTable = new HashMap<Integer, EntityType>();
        this.ot1Model = this.ot1Factory.createDocumentRoot();
        OT1Type1 ot1Version = this.ot1Factory.createOT1Type1();
        ot1Version.setVersion(VersionType._02);
        this.ot1Model.setOT1(ot1Version);
    }

    private void reset() {
        this.headerContent = null;
        this.typeTable = null;
        this.taskEventTable = null;
        this.interruptEventTable = null;
        this.runnableEventTable = null;
        this.codeBlockEventTable = null;
        this.signalEventTable = null;
        this.semaphoreEventTable = null;
        this.entityTable = null;
        this.entityTypeTable = null;
        this.ot1Model = null;
    }

    private String getHtfKeyword(String key) {
        return String.valueOf("#") + key;
    }

    private long createUuid() {
        return this.uuid++;
    }

    private void readHeader(Scanner header) {
        HeaderKey[] headerKeys = HeaderKey.values();
        String keyword = "";
        String content = "";
        while (header.hasNext()) {
            keyword = header.next();
            header.skip(header.delimiter());
            content = header.nextLine();
            int i = 0;
            while (i < headerKeys.length) {
                if (keyword.equalsIgnoreCase(String.valueOf("#") + headerKeys[i].toString())) {
                    this.headerContent.put(headerKeys[i].toString(), content);
                }
                ++i;
            }
        }
    }

    private void readLookUpTables(Scanner lookUpTables) {
        Scanner table;
        lookUpTables.useDelimiter(this.getHtfKeyword("TaskEventTable"));
        Throwable throwable = null;
        Object var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.typeTable = this.readTable(table, this.getHtfKeyword("TypeTable"), EntityType.class);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lookUpTables.useDelimiter(this.getHtfKeyword("ISREventTable"));
        throwable = null;
        var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.taskEventTable = this.readTable(table, this.getHtfKeyword("TaskEventTable"), TaskEvent.class);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        lookUpTables.useDelimiter(this.getHtfKeyword("RunnableEventTable"));
        throwable = null;
        var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.interruptEventTable = this.readTable(table, this.getHtfKeyword("ISREventTable"), InterruptEvent.class);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        lookUpTables.useDelimiter(this.getHtfKeyword("CodeBlockEventTable"));
        throwable = null;
        var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.runnableEventTable = this.readTable(table, this.getHtfKeyword("RunnableEventTable"), RunnableEvent.class);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        lookUpTables.useDelimiter(this.getHtfKeyword("SignalEventTable"));
        throwable = null;
        var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.codeBlockEventTable = this.readTable(table, this.getHtfKeyword("CodeBlockEventTable"), CodeBlockEvent.class);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        lookUpTables.useDelimiter(this.getHtfKeyword("SemaphoreEventTable"));
        throwable = null;
        var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.signalEventTable = this.readTable(table, this.getHtfKeyword("SignalEventTable"), SignalEvent.class);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
        lookUpTables.useDelimiter(this.getHtfKeyword("EntityTable"));
        throwable = null;
        var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.semaphoreEventTable = this.readTable(table, this.getHtfKeyword("SemaphoreEventTable"), SemaphoreEvent.class);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
            } else if (throwable != throwable8) {
                throwable.addSuppressed(throwable8);
            }
            throw throwable;
        }
        lookUpTables.useDelimiter(this.getHtfKeyword("EntityTypeTable"));
        throwable = null;
        var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.readEntityTable(table);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
            } else if (throwable != throwable9) {
                throwable.addSuppressed(throwable9);
            }
            throw throwable;
        }
        throwable = null;
        var3_12 = null;
        try {
            table = new Scanner(lookUpTables.next());
            try {
                this.readEntityTypeTable(table);
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        }
        catch (Throwable throwable10) {
            if (throwable == null) {
                throwable = throwable10;
            } else if (throwable != throwable10) {
                throwable.addSuppressed(throwable10);
            }
            throw throwable;
        }
    }

    private <T extends Enum<T>> Map<Integer, T> readTable(Scanner scanner, String tableKey, Class<T> enumClass) {
        Pattern entityIDPrefix = Pattern.compile("#-");
        HashMap<Integer, Enum> map = new HashMap<Integer, Enum>();
        String id = "";
        String value = "";
        if (scanner.hasNext(tableKey)) {
            scanner.nextLine();
        }
        while (scanner.hasNext()) {
            scanner.skip(entityIDPrefix);
            id = scanner.next();
            scanner.skip(scanner.delimiter());
            value = scanner.nextLine();
            for (Enum key : EnumSet.allOf(enumClass)) {
                if (!value.equalsIgnoreCase(key.toString())) continue;
                map.put(Integer.valueOf(id, 16), key);
            }
        }
        return map;
    }

    private void readEntityTable(Scanner table) {
        Pattern entityIDPrefix = Pattern.compile("#-");
        String tableKey = this.getHtfKeyword("EntityTable");
        String entityID = "";
        String entityName = "";
        if (table.hasNext(tableKey)) {
            table.nextLine();
        }
        while (table.hasNext()) {
            table.skip(entityIDPrefix);
            entityID = table.next();
            table.skip(table.delimiter());
            entityName = table.nextLine();
            this.entityTable.put(Integer.parseInt(entityID, 16), entityName);
        }
    }

    private void readEntityTypeTable(Scanner table) {
        Pattern entityIDPrefix = Pattern.compile("#-");
        String tableKey = this.getHtfKeyword("EntityTypeTable");
        String entityID = "";
        String typeID = "";
        if (table.hasNext(tableKey)) {
            table.nextLine();
        }
        table.nextLine();
        while (table.hasNext()) {
            table.skip(entityIDPrefix);
            entityID = table.next();
            table.skip(table.delimiter());
            typeID = table.nextLine();
            EntityType entityType = this.typeTable.get(Integer.parseInt(typeID, 16));
            this.entityTypeTable.put(Integer.parseInt(entityID, 16), entityType);
        }
    }

    private <T extends Enum<T>> EList<EventIdMappingType> getOT1EventTypes(Map<Integer, T> map) {
        BasicEList mapping = new BasicEList();
        EventTypeEnum ot1Event = null;
        for (Enum htfEvent : map.values()) {
            ot1Event = this.htf2OT1mapping.getOT1Event(htfEvent);
            if (ot1Event == null) continue;
            EventIdMappingType eventIDMapping = this.ot1Factory.createEventIdMappingType();
            eventIDMapping.setEventId(BigInteger.valueOf(this.htf2OT1mapping.getOT1EventID(htfEvent)));
            eventIDMapping.setEventType(ot1Event);
            mapping.add((Object)eventIDMapping);
        }
        return mapping;
    }

    private void addUnregisteredIDMappings(EList<EventIdMappingType> registeredMappings, EList<EventIdMappingType> additionalMappings) {
        BasicEList newMappings = new BasicEList();
        boolean mappingUnregistered = true;
        for (EventIdMappingType newEventIDMapping : additionalMappings) {
            for (EventIdMappingType registeredEventIDMapping : registeredMappings) {
                if (!registeredEventIDMapping.getEventId().equals(newEventIDMapping.getEventId())) continue;
                mappingUnregistered = false;
            }
            if (mappingUnregistered) {
                newMappings.add((Object)newEventIDMapping);
            }
            mappingUnregistered = true;
        }
        registeredMappings.addAll((Collection)newMappings);
    }

    private SchedulingEntityType prepareSchedulingEntity(long uuid) {
        AutosarOsType scheduler = this.ot1Factory.createAutosarOsType();
        EventDescriptionType eventDescription = this.ot1Factory.createEventDescriptionType();
        scheduler.setUuid(uuid);
        scheduler.setEventDescription(eventDescription);
        eventDescription.getEventIdMapping().addAll(this.getOT1EventTypes(this.taskEventTable));
        this.addUnregisteredIDMappings((EList<EventIdMappingType>)eventDescription.getEventIdMapping(), this.getOT1EventTypes(this.interruptEventTable));
        this.addUnregisteredIDMappings((EList<EventIdMappingType>)eventDescription.getEventIdMapping(), this.getOT1EventTypes(this.runnableEventTable));
        this.addUnregisteredIDMappings((EList<EventIdMappingType>)eventDescription.getEventIdMapping(), this.getOT1EventTypes(this.codeBlockEventTable));
        this.addUnregisteredIDMappings((EList<EventIdMappingType>)eventDescription.getEventIdMapping(), this.getOT1EventTypes(this.signalEventTable));
        this.addUnregisteredIDMappings((EList<EventIdMappingType>)eventDescription.getEventIdMapping(), this.getOT1EventTypes(this.semaphoreEventTable));
        for (Integer key : this.entityTypeTable.keySet()) {
            SchedulingEntityElementType schedulingElement = this.htf2OT1mapping.getOT1SchedulingEntityElement(this.entityTypeTable.get(key));
            schedulingElement.setId(BigInteger.valueOf(key.intValue()));
            schedulingElement.setName(this.entityTable.get(key));
            schedulingElement.setTimingConstraints(this.ot1Factory.createTimingConstraintsType());
            schedulingElement.setTimingValues(this.ot1Factory.createTimingValuesType());
            scheduler.getElement().add((Object)schedulingElement);
        }
        return scheduler;
    }

    private void convertTraceEntries(Scanner trace) {
        trace.useDelimiter("#-");
        trace.next();
        int timestampLength = Integer.parseInt(this.headerContent.get(HeaderKey.TIMESTAMPLENGTH.toString())) * 2;
        int entityLength = Integer.parseInt(this.headerContent.get(HeaderKey.ENTITYLENGTH.toString())) * 2;
        int eventLength = Integer.parseInt(this.headerContent.get(HeaderKey.EVENTLENGTH.toString())) * 2;
        int entryLength = timestampLength + eventLength + entityLength;
        int firstEventIdx = entryLength - eventLength;
        int firstEntityIdx = firstEventIdx - entityLength;
        while (trace.hasNext()) {
            Scanner coreTrace = new Scanner(trace.next());
            int coreID = Integer.parseInt(coreTrace.next(), 16);
            SchedulingEntityType scheduler = this.prepareSchedulingEntity(this.createUuid());
            TracesType traceType = this.ot1Factory.createTracesType();
            XmlTraceType xmlTraceType = this.ot1Factory.createXmlTraceType();
            ClockType clock = this.ot1Factory.createClockType();
            TimeValueType tickduration = this.ot1Factory.createTimeValueType();
            tickduration.setUnit(TimeBaseEnum.NS);
            tickduration.setNominator(new BigInteger(this.headerContent.get(HeaderKey.TIMESCALENUMERATOR.toString())));
            tickduration.setDenominator(new BigInteger(this.headerContent.get(HeaderKey.TIMESCALEDENOMINATOR.toString())));
            clock.setTickduration(tickduration);
            clock.setMaxAbsTime(BigInteger.valueOf(Integer.MAX_VALUE));
            scheduler.setClock(clock);
            scheduler.setName("Core" + coreID);
            scheduler.setTraces(traceType);
            xmlTraceType.setUuid(this.createUuid());
            traceType.getXmlTrace().add((Object)xmlTraceType);
            while (coreTrace.hasNext()) {
                long ot1EventID;
                String htfTraceEntry = coreTrace.next();
                if (htfTraceEntry.isEmpty()) continue;
                int htfEventID = Integer.valueOf(htfTraceEntry.substring(firstEventIdx, entryLength), 16);
                int htfEntityID = Integer.valueOf(htfTraceEntry.substring(firstEntityIdx, firstEventIdx), 16);
                long timestamp = Integer.valueOf(htfTraceEntry.substring(0, firstEntityIdx), 16).intValue();
                TraceEntryType ot1TraceEntry = this.ot1Factory.createTraceEntryType();
                ot1TraceEntry.setTime(BigInteger.valueOf(timestamp));
                ot1TraceEntry.setElementRefId(BigInteger.valueOf(htfEntityID));
                EntityType htfType = this.entityTypeTable.get(new Integer(htfEntityID));
                switch (htfType) {
                    case TASK: {
                        ot1EventID = this.htf2OT1mapping.getOT1EventID(this.taskEventTable.get(htfEventID));
                        break;
                    }
                    case ISR: {
                        ot1EventID = this.htf2OT1mapping.getOT1EventID(this.interruptEventTable.get(htfEventID));
                        break;
                    }
                    case RUNNABLE: {
                        ot1EventID = this.htf2OT1mapping.getOT1EventID(this.runnableEventTable.get(htfEventID));
                        break;
                    }
                    case CODEBLOCK: {
                        ot1EventID = this.htf2OT1mapping.getOT1EventID(this.codeBlockEventTable.get(htfEventID));
                        break;
                    }
                    case SIGNAL: {
                        ot1EventID = this.htf2OT1mapping.getOT1EventID(this.signalEventTable.get(htfEventID));
                        break;
                    }
                    case SEMAPHORE: {
                        ot1EventID = this.htf2OT1mapping.getOT1EventID(this.semaphoreEventTable.get(htfEventID));
                        break;
                    }
                    default: {
                        ot1EventID = -1L;
                    }
                }
                ot1TraceEntry.setEventId(BigInteger.valueOf(ot1EventID));
                xmlTraceType.getTraceEntry().add((Object)ot1TraceEntry);
            }
            this.ot1Model.getOT1().getSchedulingEntity().add((Object)scheduler);
            coreTrace.close();
        }
    }

    public DocumentRoot convertHtf2Ot1(String filename) {
        this.init();
        DocumentRoot model = this.ot1Model;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Scanner scanner = new Scanner(new BufferedReader(new FileReader(filename)));){
                Scanner htfPart;
                scanner.useDelimiter(this.getHtfKeyword("TypeTable"));
                Throwable throwable2 = null;
                Object var7_13 = null;
                try {
                    htfPart = new Scanner(scanner.next());
                    try {
                        this.readHeader(htfPart);
                    }
                    finally {
                        if (htfPart != null) {
                            htfPart.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                scanner.useDelimiter(this.getHtfKeyword("Tracedata"));
                throwable2 = null;
                var7_13 = null;
                try {
                    htfPart = new Scanner(scanner.next());
                    try {
                        this.readLookUpTables(htfPart);
                    }
                    finally {
                        if (htfPart != null) {
                            htfPart.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                throwable2 = null;
                var7_13 = null;
                try {
                    htfPart = new Scanner(scanner.next());
                    try {
                        this.convertTraceEntries(htfPart);
                    }
                    finally {
                        if (htfPart != null) {
                            htfPart.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
                scanner.close();
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reset();
        return model;
    }

    public static enum CodeBlockEvent {
        START,
        STOP;

    }

    public static enum EntityType {
        TASK,
        ISR,
        RUNNABLE,
        CODEBLOCK,
        SIGNAL,
        SEMAPHORE;

    }

    public static enum HeaderKey {
        FORMAT,
        VERSION,
        URL,
        PROJECT,
        TARGETSYSTEM,
        DESCRIPTION,
        CREATIONDATE,
        TIMESCALE,
        TIMESCALENUMERATOR,
        TIMESCALEDENOMINATOR,
        TIMESTAMPLENGTH,
        ENTITYLENGTH,
        EVENTLENGTH;

    }

    public static enum InterruptEvent {
        START,
        RESUME,
        PREEMPT,
        TERMINATE;

    }

    public static enum RunnableEvent {
        START,
        SUSPEND,
        RESUME,
        TERMINATE;

    }

    public static enum SemaphoreEvent {
        LOCK,
        UNLOCK;

    }

    public static enum SignalEvent {
        READ,
        WRITE;

    }

    public static enum TaskEvent {
        ACTIVATE,
        START,
        RESUME,
        PREEMPT,
        TERMINATE,
        WAIT,
        RELEASE,
        POLL,
        RUN_POLLING,
        PARK,
        POLL_PARKING,
        RELEASE_PARKING;

    }
}

