/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.ui.ProfileDialogSettings;
import org.eclipse.app4mc.validation.ui.provider.ProfileContentProvider;
import org.eclipse.app4mc.validation.ui.provider.ProfileLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class ProfileDialog
extends CheckedTreeSelectionDialog {
    private ProfileDialogSettings settings;

    public ProfileDialog(Shell parentShell, ProfileDialogSettings set) {
        this(parentShell, (ILabelProvider)new ProfileLabelProvider(), (ITreeContentProvider)new ProfileContentProvider(), set);
    }

    public ProfileDialog(Shell parentShell, ILabelProvider labelProvider, ITreeContentProvider contentProvider, ProfileDialogSettings set) {
        super(parentShell, labelProvider, contentProvider);
        this.settings = set != null ? set : new ProfileDialogSettings();
        this.initializeDialog();
    }

    protected void setReturnCode(int code) {
        if (code == 0) {
            this.settings.dialogSuccess = true;
            this.saveDialogResults();
        }
        super.setReturnCode(code);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 300;
        label.setLayoutData((Object)gd);
        return label;
    }

    private void initializeDialog() {
        this.setContainerMode(true);
        this.setMessage("Choose profiles");
        this.setTitle("Validations");
        this.setInput(this.settings);
        Object[] initialSelections = this.settings.getSelectedNodes();
        this.setInitialSelections(initialSelections);
        HashSet<TreeNode> set = new HashSet<TreeNode>();
        Object[] objectArray = initialSelections;
        int n = initialSelections.length;
        int n2 = 0;
        while (n2 < n) {
            Object treeNode = objectArray[n2];
            ProfileDialog.collectParents((TreeNode)treeNode, set);
            ++n2;
        }
        this.setExpandedElements(set.stream().toArray());
    }

    private void saveDialogResults() {
        Object[] dialogResults = this.getResult();
        if (dialogResults == null) {
            return;
        }
        List<TreeNode> filteredNodes = ProfileDialog.filterResult(dialogResults);
        ArrayList<Class<? extends IProfile>> selectedProfiles = new ArrayList<Class<? extends IProfile>>();
        for (TreeNode node : filteredNodes) {
            Class cls;
            Object value = node.getValue();
            if (value == null || !(value instanceof Class) || !IProfile.class.isAssignableFrom(cls = (Class)value)) continue;
            Class<IProfile> profileClass = cls.asSubclass(IProfile.class);
            selectedProfiles.add(profileClass);
        }
        this.settings.dialogResults = selectedProfiles;
    }

    private static List<TreeNode> filterResult(Object[] dialogResults) {
        ArrayList<TreeNode> initialNodes = new ArrayList<TreeNode>();
        HashSet<TreeNode> nodesToRemove = new HashSet<TreeNode>();
        Object[] objectArray = dialogResults;
        int n = dialogResults.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof TreeNode) {
                initialNodes.add((TreeNode)obj);
            }
            ++n2;
        }
        for (TreeNode node : initialNodes) {
            if (!node.hasChildren() || nodesToRemove.contains(node) || !Arrays.stream(node.getChildren()).anyMatch(c -> !initialNodes.contains(c))) continue;
            nodesToRemove.add(node);
            nodesToRemove.addAll(ProfileDialog.getParents(node));
        }
        for (TreeNode node : initialNodes) {
            if (!node.hasChildren() || nodesToRemove.contains(node)) continue;
            nodesToRemove.addAll(ProfileDialog.getChildren(node));
        }
        initialNodes.removeAll(nodesToRemove);
        return initialNodes;
    }

    private static List<TreeNode> getParents(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        ProfileDialog.collectParents(node, list);
        return list;
    }

    private static void collectParents(TreeNode node, Collection<TreeNode> collection) {
        TreeNode parent = node.getParent();
        while (parent != null) {
            collection.add(parent);
            parent = parent.getParent();
        }
    }

    private static List<TreeNode> getChildren(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        ProfileDialog.collectChildren(node, list);
        return list;
    }

    private static void collectChildren(TreeNode node, Collection<TreeNode> collection) {
        if (node.hasChildren()) {
            TreeNode[] treeNodeArray = node.getChildren();
            int n = treeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode child = treeNodeArray[n2];
                collection.add(child);
                ProfileDialog.collectChildren(child, collection);
                ++n2;
            }
        }
    }
}

