/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters072.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters072.utils.HelperUtils_071_072;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ConfigConverter
extends AbstractConverter {
    public ConfigConverter() {
        this.helper = HelperUtils_071_072.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.7.1 to 0.7.2 : Executing \"Config Model\" converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateEventConfig(rootElement);
    }

    private void updateEventConfig(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./configModel/eventsToTrace");
        List eventsToTracelements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        if (eventsToTracelements.size() > 0) {
            Element eventModel = rootElement.getChild("eventModel");
            if (eventModel == null) {
                eventModel = new Element("eventModel");
                rootElement.addContent((Content)eventModel);
            }
            for (Element eventsToTracelement : eventsToTracelements) {
                Element eventElement;
                String tagType = eventsToTracelement.getAttributeValue("type", this.helper.getGenericNS("xsi"));
                eventsToTracelement.removeAttribute("type", this.helper.getGenericNS("xsi"));
                if (!tagType.equals("am:EventConfigElement") || (eventElement = eventsToTracelement.getChild("event")) == null) continue;
                eventElement.setName("events");
                eventsToTracelement.removeContent((Content)eventElement);
                eventModel.addContent((Content)eventElement);
                eventsToTracelement.getParent().removeContent((Content)eventsToTracelement);
            }
        }
    }
}

