/**
 ********************************************************************************
 * Copyright (c) 2019 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */

package org.eclipse.app4mc.amalthea.converters096.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters096.utils.HelperUtils_095_096;
import org.jdom2.Document;
import org.jdom2.Element;

public class SwConverter extends AbstractConverter {

	public SwConverter() {
		this.helper = HelperUtils_095_096.getInstance();
		this.logger = LogManager.getLogger("org.eclipse.app4mc.amalthea.modelmigration");
	}

	@Override
	public void convert(final File file, final Map<File, Document> map, final List<ICache> caches) throws Exception {

		this.logger.info("Migration from 0.9.5 to 0.9.6 : Executing Sw converter for model file : " + file.getName());

		basicConvert(file, map, caches);
	}

	public void basicConvert(final File file, final Map<File, Document> map, final List<ICache> caches) {

		final Document document = map.get(file);
		if (document == null) {
			return;
		}

		final Element rootElement = document.getRootElement();

		updateCustomPropsToCounter(rootElement);
		
		updateModeConditions(rootElement);
	}
	
	private void updateModeConditions(Element rootElement) {
		updateModeCondition(rootElement);
		updateModeConditionConjunction(rootElement);
	}

	private void updateModeCondition(Element rootElement) {
		 final StringBuffer xpathBuffer = new StringBuffer();
		 
		 xpathBuffer.append("./swModel/tasks/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
		 xpathBuffer.append("|");
		 xpathBuffer.append("./swModel/isrs/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
		 xpathBuffer.append("|");
		 xpathBuffer.append("./swModel/runnables/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
		 xpathBuffer.append("|");
		 xpathBuffer.append("./swModel/runnables/executionCondition//entries[@xsi:type=\"am:ModeCondition\"]");
		 xpathBuffer.append("|");
		 xpathBuffer.append("./stimuliModel/stimuli/executionCondition//entries[@xsi:type=\"am:ModeCondition\"]");
		 
		 final List<Element> modeCondition = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class,
					this.helper.getNS_096("am"), this.helper.getGenericNS("xsi"));
		 
		 for (Element element : modeCondition) {
			element.setAttribute("type", "am:ModeValueCondition", this.helper.getGenericNS("xsi"));
		}
	}
	
	private void updateModeConditionConjunction(Element rootElement) {
		final StringBuffer xpathBuffer = new StringBuffer();
		 
		 xpathBuffer.append("./swModel/tasks/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
		 xpathBuffer.append("|");
		 xpathBuffer.append("./swModel/isrs/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
		 xpathBuffer.append("|");
		 xpathBuffer.append("./swModel/runnables/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
		 xpathBuffer.append("|");
		 xpathBuffer.append("./swModel/runnables/executionCondition//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
		 xpathBuffer.append("|");
		 xpathBuffer.append("./stimuliModel/stimuli/executionCondition//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
		 
		 final List<Element> modeConditions = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class,
					this.helper.getNS_096("am"), this.helper.getGenericNS("xsi"));
		 
		 for (Element element : modeConditions) {
			 List<Element> entries = element.getChildren("entries");
			 for (Element entry : entries) {
				entry.setAttribute("type", "am:ModeValueCondition", this.helper.getGenericNS("xsi"));
			}
		}
	}

	private void updateCustomPropsToCounter(Element rootElement) {
		//bring back counter for RunnableCall if the custom properties have counter info.
		
		 final StringBuffer xpathBuffer = new StringBuffer();
		 
		xpathBuffer.append("./swModel/tasks/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
		xpathBuffer.append("|");
		xpathBuffer.append("./swModel/isrs/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
		xpathBuffer.append("|");
		xpathBuffer.append("./swModel/runnables/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
		
		final List<Element> customProps = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class,
				this.helper.getNS_096("am"), this.helper.getGenericNS("xsi"));
		
		for (Element element : customProps) {
			Element parentElement = element.getParentElement();
			
			List<Element> customProperties = new ArrayList<Element>(parentElement.getChildren("customProperties"));
			//create counter
			Element counter = new Element("counter");
			parentElement.addContent(counter);
			
			for (Element prop : customProperties) {
				if(prop.getAttributeValue("key").equals("counter-prescaler")) {
					counter.setAttribute("prescaler", prop.getChild("value").getAttributeValue("value"));
					//remove custom prop
					prop.detach();
					continue;
				}
				
				if(prop.getAttributeValue("key").equals("counter-offset")) {					
					counter.setAttribute("offset", prop.getChild("value").getAttributeValue("value"));
					//remove custom prop
					prop.detach();
				}
			}
			
			
		}
	}
 

}
