/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.editors.sirius.design.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.app4mc.amalthea.editors.sirius.command.OpenGraphicalEditorAction;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.Preemption;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DNodeContainer;

public class TaskService {
    public boolean checkTaskPreemptive(Task task) {
        return task != null && task.getPreemption().equals((Object)Preemption.PREEMPTIVE);
    }

    public boolean checkTaskPreemptionUnknown(Task task) {
        return task != null && task.getPreemption().equals((Object)Preemption._UNDEFINED_);
    }

    public List<Runnable> getRunnablesFromTask(Task task) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        if (task != null && task.getCallGraph() != null) {
            TreeIterator iter = EcoreUtil.getAllContents((Collection)task.getCallGraph().getItems());
            while (iter.hasNext()) {
                EObject item = (EObject)iter.next();
                if (!(item instanceof RunnableCall) || ((RunnableCall)item).getRunnable() == null) continue;
                result.add(((RunnableCall)item).getRunnable());
            }
        }
        return result;
    }

    public List<Label> getAccessedLabelsOfTask(Task task) {
        ArrayList<Label> result = new ArrayList<Label>();
        List<Runnable> runnables = this.getRunnablesFromTask(task);
        for (Runnable runnable : runnables) {
            TreeIterator iter = EcoreUtil.getAllContents((Collection)runnable.getRunnableItems());
            while (iter.hasNext()) {
                EObject item = (EObject)iter.next();
                if (!(item instanceof LabelAccess) || ((LabelAccess)item).getData() == null) continue;
                result.add(((LabelAccess)item).getData());
            }
        }
        return result;
    }

    public void openTaskEditor(DNodeContainer container, Task task) {
        new OpenGraphicalEditorAction(Task.class, (IReferable)task).executeWithUIThread();
    }
}

