/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.editor;

import java.util.HashMap;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.SphinxSupportPlugin;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.editor.ExtendedContentsTreePage;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.editor.ExtendedItemProviderAdapterFactory;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.editors.forms.BasicTransactionalFormEditor;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.ui.util.EcoreUIUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.editor.IFormPage;

public class ExtendedBasicTransactionalFormEditor
extends BasicTransactionalFormEditor
implements IResourceChangeListener {
    private static final String AMALTHEA_MODEL_ID = "org.eclipse.app4mc.amalthea.model";
    private static final String SHOW_TYPES_OF_ELEMENTS = "show_types_of_elements";

    protected AdapterFactory getCustomAdapterFactory() {
        return ExtendedItemProviderAdapterFactory.INSTANCE;
    }

    protected String getEditorInputName() {
        IEditorInput editorInput = this.getEditorInput();
        URI editorURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)editorInput);
        if (editorURI != null) {
            String fileName = editorURI.lastSegment();
            return fileName;
        }
        return super.getEditorInputName();
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new ExtendedContentsTreePage(this));
        }
        catch (PartInitException e) {
            PlatformLogUtil.logAsError((Plugin)SphinxSupportPlugin.getDefault(), (Object)((Object)e));
        }
        this.addResourceChangeListener();
    }

    public void setShowTypesOfElements(boolean showTypes) {
        SphinxSupportPlugin.getDefault().getDialogSettings().put(SHOW_TYPES_OF_ELEMENTS, showTypes);
    }

    public boolean isShowTypesOfElements() {
        return SphinxSupportPlugin.getDefault().getDialogSettings().getBoolean(SHOW_TYPES_OF_ELEMENTS);
    }

    public void addResourceChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        IEditorPart editorPart = page.getActiveEditor();
        if (!(editorPart instanceof ExtendedBasicTransactionalFormEditor)) {
            return;
        }
        final ExtendedBasicTransactionalFormEditor activeEditor = (ExtendedBasicTransactionalFormEditor)editorPart;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Viewer viewer = activeEditor.getViewer();
                if (viewer != null) {
                    viewer.refresh();
                }
            }
        });
    }

    public void setSelection(ISelection selection) {
        Control control;
        super.setSelection(selection);
        if (!Util.isWindows()) {
            return;
        }
        MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        if (application == null) {
            return;
        }
        IEclipseContext context = application.getContext();
        if (context == null) {
            return;
        }
        IThemeEngine engine = (IThemeEngine)context.get(IThemeEngine.class);
        if (engine == null) {
            return;
        }
        Viewer viewer = this.getViewer();
        if (viewer != null && (control = viewer.getControl()) != null) {
            control.redraw();
        }
    }

    protected void createPages() {
        if (!this.isFileContainingValidModelNameSpace()) {
            return;
        }
        super.createPages();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFileContainingValidModelNameSpace() {
        String versionFromMetaModel;
        IModelDescriptor modelDescriptorContent;
        IFile iFileObject;
        block19: {
            if (this.getEditorInputObject() != null) {
                return true;
            }
            IEditorInput editorInput = this.getEditorInput();
            iFileObject = EcoreUIUtil.getFileFromEditorInput((IEditorInput)editorInput);
            try {
                IProjectNature nature = iFileObject.getProject().getNature("amlt.no.load.nature");
                if (nature == null) break block19;
                MessageDialog dialog = new MessageDialog(this.getSite().getShell(), "AMALTHEA Model Editor", null, "File is not loaded as Amalthea \"no load\" nature is configured", 4, 0, new String[]{"OK", "Remove \"no load\" nature"});
                int open = dialog.open();
                if (open == 1) {
                    ICommandService cmdService = (ICommandService)this.getSite().getService(ICommandService.class);
                    Command sampleCommand = cmdService.getCommand("org.eclipse.app4mc.amalthea.noload.nature.remove");
                    HashMap params = new HashMap();
                    if (open == 1) {
                        try {
                            StructuredSelection selection = new StructuredSelection((Object)iFileObject.getProject());
                            EvaluationContext context = new EvaluationContext(null, (Object)selection);
                            context.addVariable("selection", (Object)selection);
                            ExecutionEvent event = new ExecutionEvent(sampleCommand, params, null, (Object)context);
                            sampleCommand.executeWithChecks(event);
                            return true;
                        }
                        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                            e.printStackTrace();
                        }
                    }
                    break block19;
                }
                if (open == 0 || open == -1) {
                    this.close(false);
                    return false;
                }
            }
            catch (CoreException coreException) {}
        }
        if ((modelDescriptorContent = ModelDescriptorRegistry.INSTANCE.getModel(iFileObject)) != null) {
            return true;
        }
        IMetaModelDescriptor metaModelDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(AMALTHEA_MODEL_ID);
        if (metaModelDescriptor == null) {
            return true;
        }
        String nsURIFromMetaModel = metaModelDescriptor.getRootEPackage().getNsURI();
        String nsURIFromModel = EcorePlatformUtil.readModelNamespace((IFile)iFileObject);
        if (nsURIFromMetaModel == null || nsURIFromModel == null) {
            return true;
        }
        if (nsURIFromModel.startsWith("http://www.amalthea.itea2.org/model/") || nsURIFromModel.startsWith("http://amalthea.itea2.org/model/")) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"AMALTHEA Model Editor", (String)"Unsupported File ! \r\rEditor could not be opened because of a legacy model file that is no longer supported.");
            this.close(false);
            return false;
        }
        String versionFromModel = nsURIFromModel.lastIndexOf("/") != -1 ? nsURIFromModel.substring(nsURIFromModel.lastIndexOf("/") + 1) : nsURIFromModel;
        String string = versionFromMetaModel = nsURIFromMetaModel.lastIndexOf("/") != -1 ? nsURIFromMetaModel.substring(nsURIFromMetaModel.lastIndexOf("/") + 1) : nsURIFromMetaModel;
        if (versionFromMetaModel.equals(versionFromModel)) {
            return true;
        }
        String versionMismatchMessage = NLS.bind((String)"Unsupported File ! \r\rEditor could not be opened because of a version mismatch. \r\rFound AMALTHEA model version : {0}\rCurrent editor supports only AMALTHEA model version :  {1}", (Object[])new Object[]{versionFromModel, versionFromMetaModel});
        if (Platform.getBundle((String)"org.eclipse.app4mc.amalthea.converters.ui") == null) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"AMALTHEA Model Editor", (String)(String.valueOf(versionMismatchMessage) + "\r\r** AMALTHEA Model Migration utility is not available"));
        } else {
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), "AMALTHEA Model Editor", null, String.valueOf(versionMismatchMessage) + "\r\r** Start AMALTHEA Model Migration utility to convert the model", 6, 0, new String[]{"Migrate to " + versionFromMetaModel, "Show Migration Dialog", "Cancel"});
            int open = dialog.open();
            if (open == 0 || open == 1) {
                ICommandService cmdService = (ICommandService)this.getSite().getService(ICommandService.class);
                Command sampleCommand = cmdService.getCommand("org.eclipse.app4mc.amalthea.modelmigration.dialog.cmd");
                HashMap<String, String> params = new HashMap<String, String>();
                if (open == 0) {
                    params.put("executioncontext", "simplemigration");
                }
                try {
                    sampleCommand.executeWithChecks(new ExecutionEvent(sampleCommand, params, null, null));
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.close(false);
        return false;
    }
}

