/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.handlers;

import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.handlers.SearchDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchDialog
extends TitleAreaDialog {
    private SearchDialogSettings settings;
    private Text txtNamePattern;
    private Label lblSyntaxDescription;
    private Button btnCaseSensitive;
    private Button btnRegularExpression;
    private Combo cmbClassFilter;
    private Composite composite;
    private Button btnScopeCurrentFile;
    private Button btnScopeFolder;

    public SearchDialog(Shell parentShell, SearchDialogSettings set) {
        super(parentShell);
        this.setShellStyle(67696);
        this.setHelpAvailable(false);
        this.settings = set != null ? set : new SearchDialogSettings();
    }

    private void copySettings2UI() {
        this.txtNamePattern.setText(this.settings.m_namePattern);
        this.btnCaseSensitive.setSelection(this.settings.m_caseSensitive);
        this.btnRegularExpression.setSelection(this.settings.m_regularExpression);
        this.lblSyntaxDescription.setVisible(!this.settings.m_regularExpression);
        this.cmbClassFilter.setItems(this.settings.getFilterClassNames());
        this.cmbClassFilter.setText(this.settings.m_filterClassName);
        this.btnScopeCurrentFile.setSelection(this.settings.m_restrictToFile);
        this.btnScopeFolder.setSelection(!this.settings.m_restrictToFile);
    }

    private void copyUI2Settings() {
        this.settings.m_namePattern = this.txtNamePattern.getText();
        this.settings.m_caseSensitive = this.btnCaseSensitive.getSelection();
        this.settings.m_regularExpression = this.btnRegularExpression.getSelection();
        this.settings.m_filterClassName = this.cmbClassFilter.getText();
        this.settings.m_restrictToFile = this.btnScopeCurrentFile.getSelection();
    }

    public void create() {
        super.create();
        this.copySettings2UI();
    }

    protected void setReturnCode(int code) {
        if (code == 0) {
            this.settings.m_success = true;
            this.copyUI2Settings();
        }
        super.setReturnCode(code);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Search for model elements");
        this.setMessage("Query the name attribute of model elements.");
        Composite dialog = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(dialog, 0);
        container.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        GridLayout layout = new GridLayout();
        layout.marginTop = 4;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText("Name:");
        this.txtNamePattern = new Text(container, 2048);
        this.txtNamePattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        this.lblSyntaxDescription = new Label(container, 0);
        this.lblSyntaxDescription.setText("(* = any string, ? = any character, \\ = escape for literals: * ? \\)");
        Label separator0 = new Label(container, 0);
        GridData gd_separator0 = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_separator0.heightHint = 8;
        separator0.setLayoutData((Object)gd_separator0);
        new Label(container, 0);
        this.btnCaseSensitive = new Button(container, 32);
        this.btnCaseSensitive.setText("Case sensitive");
        new Label(container, 0);
        this.btnRegularExpression = new Button(container, 32);
        this.btnRegularExpression.setText("Regular expression");
        Label separator1 = new Label(container, 258);
        GridData gd_separator1 = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_separator1.heightHint = 8;
        separator1.setLayoutData((Object)gd_separator1);
        Label lblFilter = new Label(container, 0);
        lblFilter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFilter.setText("Filter:");
        this.cmbClassFilter = new Combo(container, 8);
        this.cmbClassFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblScope = new Label(container, 0);
        lblScope.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblScope.setText("Scope:");
        this.composite = new Composite(container, 0);
        FillLayout fl_composite = new FillLayout(256);
        fl_composite.spacing = 10;
        this.composite.setLayout((Layout)fl_composite);
        this.composite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnScopeCurrentFile = new Button(this.composite, 16);
        this.btnScopeCurrentFile.setText("Current file");
        this.btnScopeFolder = new Button(this.composite, 16);
        this.btnScopeFolder.setText("Folder");
        this.btnScopeFolder.setSelection(true);
        Label separator2 = new Label(container, 258);
        GridData gd_separator2 = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_separator2.heightHint = 8;
        separator2.setLayoutData((Object)gd_separator2);
        this.btnRegularExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.lblSyntaxDescription.setVisible(!SearchDialog.this.btnRegularExpression.getSelection());
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button searchButton = this.getButton(0);
        searchButton.setText("Search");
    }
}

