/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.hardware;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.Cache;
import org.eclipse.app4mc.amalthea.model.ConnectionHandler;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-HW-Module-Definition")
public class AmHwModuleDefinition
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getHwModule();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof HwModule) {
            Cache cache;
            ConnectionHandler handler;
            ProcessingUnit pu;
            Memory memory;
            HwModule module = (HwModule)object;
            if (module instanceof Memory && (memory = (Memory)module).getDefinition() == null) {
                this.addIssue(results, (EObject)memory, (EStructuralFeature)ePackage.getMemory_Definition(), "HW Module (Memory) " + this.name((INamed)module) + ": missing definition");
            }
            if (module instanceof ProcessingUnit && (pu = (ProcessingUnit)module).getDefinition() == null) {
                this.addIssue(results, (EObject)pu, (EStructuralFeature)ePackage.getProcessingUnit_Definition(), "HW Module (ProcessingUnit) " + this.name((INamed)module) + ": missing definition");
            }
            if (module instanceof ConnectionHandler && (handler = (ConnectionHandler)module).getDefinition() == null) {
                this.addIssue(results, (EObject)handler, (EStructuralFeature)ePackage.getConnectionHandler_Definition(), "HW Module (ConnectionHandler) " + this.name((INamed)module) + ": missing definition");
            }
            if (module instanceof Cache && (cache = (Cache)module).getDefinition() == null) {
                this.addIssue(results, (EObject)cache, (EStructuralFeature)ePackage.getCache_Definition(), "HW Module (Cache) " + this.name((INamed)module) + ": missing definition");
            }
        }
    }
}

