/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.util;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.util.CachedProfile;
import org.eclipse.app4mc.validation.util.CachedValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public class ProfileManager {
    private final Map<Class<? extends IProfile>, CachedProfile> profileMap = new HashMap<Class<? extends IProfile>, CachedProfile>();

    public static Map<String, Class<? extends IProfile>> getRegisteredProfileClasses() {
        IConfigurationElement[] extensions;
        HashMap<String, Class<? extends IProfile>> result = new HashMap<String, Class<? extends IProfile>>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            return result;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.validation.profile");
        if (extensionPoint == null) {
            return result;
        }
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionPoint.getConfigurationElements();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String id = iConfigurationElement.getAttribute("id");
            Class<?> cls = null;
            try {
                Object obj = iConfigurationElement.createExecutableExtension("class");
                cls = obj.getClass();
            }
            catch (CoreException coreException) {}
            if (cls != null && IProfile.class.isAssignableFrom(cls)) {
                Class<IProfile> profileClass = cls.asSubclass(IProfile.class);
                result.put(id, profileClass);
            }
            ++n2;
        }
        return result;
    }

    public void clearProfiles() {
        this.profileMap.clear();
    }

    public void loadProfile(Class<? extends IProfile> profileClass) {
        if (profileClass == null) {
            return;
        }
        this.profileMap.put(profileClass, new CachedProfile(profileClass));
    }

    public CachedProfile getCachedProfile(Class<? extends IProfile> profileClass) {
        if (profileClass == null) {
            return null;
        }
        if (!this.profileMap.containsKey(profileClass)) {
            this.loadProfile(profileClass);
        }
        return this.profileMap.get(profileClass);
    }

    public void dumpProfile(Class<? extends IProfile> profileClass, PrintStream stream) {
        PrintStream out = stream == null ? System.out : stream;
        CachedProfile profile = this.getCachedProfile(profileClass);
        this.dumpProfile(profile, 0, out);
    }

    private void dumpProfile(CachedProfile profile, int indent, PrintStream stream) {
        if (profile == null) {
            return;
        }
        String in = "";
        int i = 0;
        while (i < indent) {
            in = String.valueOf(in) + "    ";
            ++i;
        }
        stream.println(String.valueOf(in) + "PROFILE " + profile.getProfileClass().getSimpleName());
        stream.println(String.valueOf(in) + " - name: " + profile.getName());
        if (!profile.getDescription().isEmpty()) {
            stream.println(String.valueOf(in) + " - description: " + profile.getDescription());
        }
        if (!profile.getCachedValidations().isEmpty()) {
            stream.println(String.valueOf(in) + " - validations:");
        }
        for (CachedValidator conf : profile.getCachedValidations().values()) {
            stream.println(String.valueOf(in) + "    " + conf.getValidationID() + "(" + (Object)((Object)conf.getSeverity()) + " - " + conf.getTargetClass().getSimpleName() + ")");
        }
        if (!profile.getCachedProfiles().isEmpty()) {
            stream.println(String.valueOf(in) + " - profiles:");
        }
        for (CachedProfile conf : profile.getCachedProfiles().values()) {
            this.dumpProfile(conf, 1, stream);
        }
    }
}

