/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils_080_081;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.8.0", "output_model_version=0.8.1"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.8.0 to 0.8.1 : Executing Software converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateRunnable(rootElement);
        this.updateActivations(rootElement);
        this.updateAllAbstractProcessElements(rootElement);
    }

    private void updateAllAbstractProcessElements(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/tasks");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/processPrototypes");
        List abstractProcessElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element abstractProcessElement : abstractProcessElements) {
            Attribute osekTaskGroupAttribute;
            Attribute priorityAttribute = abstractProcessElement.getAttribute("priority");
            if (priorityAttribute != null) {
                String value = priorityAttribute.getValue();
                abstractProcessElement.removeAttribute(priorityAttribute);
                if (!value.equals("0")) {
                    Element customPropertiesElement = new Element("customProperties");
                    customPropertiesElement.setAttribute("key", "priority");
                    Element valueElement = new Element("value");
                    valueElement.setAttribute("type", "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                    valueElement.setAttribute("value", value);
                    customPropertiesElement.addContent((Content)valueElement);
                    abstractProcessElement.addContent((Content)customPropertiesElement);
                    LOGGER.info("Priority is removed from : {} element ({}) and added as a CustomProperty with key as Priority", (Object)abstractProcessElement.getName(), (Object)abstractProcessElement.getAttributeValue("name"));
                }
            }
            if (!abstractProcessElement.getName().equals("tasks") || (osekTaskGroupAttribute = abstractProcessElement.getAttribute("osekTaskGroup")) == null) continue;
            String osekTaskGroupValue = osekTaskGroupAttribute.getValue();
            abstractProcessElement.removeAttribute(osekTaskGroupAttribute);
            if (osekTaskGroupValue.equals("0")) continue;
            HelperUtils_080_081.addCustomProperty(abstractProcessElement, "osekTaskGroup", osekTaskGroupValue);
            LOGGER.info("osekTaskGroup attribute is removed from Task ({}) and added as a CustomProperty with key as osekTaskGroup", (Object)abstractProcessElement.getAttributeValue("name"));
        }
    }

    private void updateRunnable(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables");
        List runnableElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element runnableElement : runnableElements) {
            Attribute activationAttribute = runnableElement.getAttribute("activation");
            Element activationElement = runnableElement.getChild("activation");
            if (activationAttribute != null) {
                activationAttribute.setName("activations");
                continue;
            }
            if (activationElement == null) continue;
            activationElement.setName("activations");
        }
    }

    private void updateActivations(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/activations");
        List activationElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        boolean removedDeadLine = false;
        for (Element activationElement : activationElements) {
            Attribute triggerAttribute;
            if (activationElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")).contains("am:PeriodicActivation")) {
                Element deadlineElement = activationElement.getChild("deadline");
                if (deadlineElement == null) continue;
                deadlineElement.detach();
                Element customPropertiesElement = new Element("customProperties");
                customPropertiesElement.setAttribute("key", "deadline");
                deadlineElement.setName("value");
                deadlineElement.setAttribute("type", "am:TimeObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                customPropertiesElement.addContent((Content)deadlineElement);
                activationElement.addContent((Content)customPropertiesElement);
                removedDeadLine = true;
                continue;
            }
            if (!activationElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")).contains("am:EventActivation")) continue;
            List triggerElements = activationElement.getChildren("trigger");
            if (triggerElements != null) {
                for (Element element : triggerElements) {
                    element.setName("triggeringEvents");
                }
            }
            if ((triggerAttribute = activationElement.getAttribute("trigger")) == null) continue;
            triggerAttribute.setName("triggeringEvents");
        }
        if (removedDeadLine) {
            LOGGER.warn("-- Deadline inside PeriodicActivation elements is removed, as there is no equivalent element for it in AMALTHEA 0.8.1");
        }
    }
}

