/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.headless.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.app4mc.amalthea.converters.headless.app.ModelMigrationCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMigrationStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMigrationStarter.class);
    protected ModelMigrationCommand command;

    protected void activate(String[] args, boolean isInteractive, boolean showConsoleLog) {
        if (args != null && args.length > 0) {
            String migrationVersion = "latest";
            boolean recursive = false;
            boolean noBackup = false;
            ArrayList<String> filenameList = new ArrayList<String>();
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.startsWith("-v") || arg.startsWith("--version")) {
                    migrationVersion = args[++i];
                } else if (arg.startsWith("-r") || arg.startsWith("--recursive")) {
                    recursive = true;
                } else if (arg.startsWith("-nb") || arg.startsWith("--nobackup")) {
                    noBackup = true;
                } else if (!arg.startsWith("-") && arg.trim().length() > 0) {
                    filenameList.add(arg);
                }
                ++i;
            }
            for (String file : filenameList) {
                this.command.convert(migrationVersion, recursive, noBackup, file);
            }
            if (showConsoleLog) {
                System.out.println();
                System.out.println("***** Press Enter to exit *****");
                try {
                    Throwable file = null;
                    Iterator iterator = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
                        reader.readLine();
                    }
                    catch (Throwable throwable) {
                        if (file == null) {
                            file = throwable;
                        } else if (file != throwable) {
                            file.addSuppressed(throwable);
                        }
                        throw file;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error on waiting for user input", (Throwable)e);
                }
            }
        }
        if (!isInteractive) {
            System.exit(0);
        }
    }
}

