/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import org.eclipse.app4mc.amalthea._import.atdb.ATDBImporter;
import org.eclipse.app4mc.amalthea._import.atdb.AmaltheaExporter;
import org.eclipse.app4mc.amalthea._import.atdb.IImporter;
import org.eclipse.app4mc.amalthea._import.atdb.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class ImportTransformation {
    private IImporter importer = null;
    AmaltheaExporter exporter = null;

    public ImportTransformation(String source, IContainer target) {
        if (source.endsWith(".atdb")) {
            this.importer = new ATDBImporter(source);
            int from = Math.max(source.lastIndexOf("/"), source.lastIndexOf("\\"));
            int to = source.lastIndexOf(".atdb");
            String name = source.substring(from + 1, to);
            URI uri = URI.createURI((String)(target.getLocationURI() + "/" + name + ".amxmi"));
            this.exporter = new AmaltheaExporter(uri);
        }
    }

    public boolean run(IProgressMonitor progressMonitor) {
        boolean result = true;
        if (this.importer != null) {
            Model model = this.importer.run(progressMonitor);
            this.exporter.serialise(progressMonitor, model);
        } else {
            result = false;
        }
        return result;
    }
}

