/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.edit.command.CommandParameter;

public class EcoreGenericsHelper {
    public static Map<ETypeParameter, EClassifier> generateGenericParameterMap(Object object) {
        EStructuralFeature containingFeature;
        EGenericType genericType;
        EList genericTypeArguments;
        EObject eObject;
        EClass eClass;
        EList typeParameters;
        HashMap<ETypeParameter, EClassifier> result = null;
        if (object instanceof EObject && (typeParameters = (eClass = (eObject = (EObject)object).eClass()).getETypeParameters()) != null && typeParameters.size() > 0 && (genericTypeArguments = (genericType = (containingFeature = eObject.eContainingFeature()).getEGenericType()).getETypeArguments()) != null && genericTypeArguments.size() > 0) {
            result = new HashMap<ETypeParameter, EClassifier>();
            int size = Math.min(typeParameters.size(), genericTypeArguments.size());
            int i = 0;
            while (i < size) {
                ETypeParameter typeParameter = (ETypeParameter)typeParameters.get(i);
                EGenericType type = (EGenericType)genericTypeArguments.get(i);
                EClassifier typeClassifier = type.getEClassifier();
                if (typeClassifier == null) {
                    Map<ETypeParameter, EClassifier> parentGenericParameterMap;
                    EObject eContainer = eObject.eContainer();
                    ETypeParameter parentTypeParameter = type.getETypeParameter();
                    if (eContainer != null && parentTypeParameter != null && (parentGenericParameterMap = EcoreGenericsHelper.generateGenericParameterMap(eContainer)) != null) {
                        typeClassifier = parentGenericParameterMap.get(parentTypeParameter);
                    }
                }
                if (typeClassifier != null) {
                    result.put(typeParameter, typeClassifier);
                }
                ++i;
            }
        }
        return result;
    }

    public static void correctChildDescriptorListForGenericTypes(Object object, Collection<Object> newChildDescriptors) {
        Map<ETypeParameter, EClassifier> genericParameterMap = EcoreGenericsHelper.generateGenericParameterMap(object);
        if (genericParameterMap != null) {
            EcoreGenericsHelper.correctChildDescriptorListForGenericTypes(genericParameterMap, newChildDescriptors);
        }
    }

    public static void correctChildDescriptorListForGenericTypes(Map<ETypeParameter, EClassifier> genericParameterMap, Collection<Object> newChildDescriptors) {
        ArrayList<Object> childDescriptorsToRemove = new ArrayList<Object>();
        for (Object cd : newChildDescriptors) {
            EReference reference;
            EGenericType genericType;
            ETypeParameter typeParameter;
            CommandParameter cp;
            if (!(cd instanceof CommandParameter) || !((cp = (CommandParameter)cd).getFeature() instanceof EReference) || (typeParameter = (genericType = (reference = (EReference)cp.getFeature()).getEGenericType()).getETypeParameter()) == null) continue;
            EClassifier expectedTypeOfValue = genericParameterMap.get(typeParameter);
            Object value = cp.getValue();
            if (expectedTypeOfValue == null || expectedTypeOfValue.isInstance(value)) continue;
            childDescriptorsToRemove.add(cd);
        }
        newChildDescriptors.removeAll(childDescriptorsToRemove);
    }
}

