/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.core;

import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.validation.core.IValidation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AmaltheaValidation
implements IValidation {
    protected static AmaltheaPackage ePackage = AmaltheaPackage.eINSTANCE;

    public EPackage getEPackage() {
        return ePackage;
    }

    protected String name(INamed object) {
        if (object == null) {
            return "?";
        }
        if (Strings.isNullOrEmpty((String)object.getName())) {
            return "?";
        }
        return "\"" + object.getName() + "\"";
    }

    protected String longName(IReferable object) {
        if (object == null) {
            return "?";
        }
        String prefix = object.getNamePrefix();
        if (prefix == null || prefix.isEmpty()) {
            return this.name((INamed)object);
        }
        return "\"" + prefix + "." + object.getName() + "\"";
    }

    protected String namedContainerInfo(EObject object) {
        return " ( in " + this.objectInfo(AmaltheaServices.getContainerOfType((EObject)object, INamed.class)) + " )";
    }

    public String objectInfo(EObject object) {
        if (object == null) {
            return "?";
        }
        String s1 = this.typeInfo(object);
        String s2 = object instanceof INamed ? " " + this.name((INamed)object) : "";
        return String.valueOf(s1) + s2;
    }

    protected void addIssue(List<ValidationDiagnostic> results, EObject object, EStructuralFeature feature, String message) {
        results.add(new ValidationDiagnostic(message, object, feature));
    }
}

