/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.software;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.CallArgument;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableParameter;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-SW-CallArgument")
public class AmSwCallArgument
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getCallArgument();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof CallArgument) {
            CallArgument argument = (CallArgument)object;
            RunnableCall runnableCall = argument.getContainingCall();
            Runnable calledRunnable = runnableCall.getRunnable();
            RunnableParameter parameter = argument.getParameter();
            if (parameter == null) {
                this.addIssue(results, (EObject)argument, (EStructuralFeature)ePackage.getCallArgument_Parameter(), "Call argument: Parameter of argument is undefined");
            }
            if (calledRunnable == null) {
                this.addIssue(results, (EObject)runnableCall, (EStructuralFeature)ePackage.getRunnableCall_Runnable(), "Call argument: Called runnable is undefined");
            }
            if (parameter == null || calledRunnable == null) {
                return;
            }
            if (!calledRunnable.getParameters().contains((Object)parameter)) {
                this.addIssue(results, (EObject)argument, (EStructuralFeature)ePackage.getCallArgument_Parameter(), "Call argument: Called Runnable \"" + calledRunnable.getName() + "\" does not match Parameter \"" + parameter.toString() + "\"");
            }
        }
    }
}

