/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.utils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.jdom2.Document;
import org.jdom2.Element;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.8.3"}, service={ICache.class, HWCacheBuilder.class})
public class HWCacheBuilder
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HWCacheBuilder.class);
    public static final String cache_key = "PeriodicStimulus_Containing_Clock";
    private final HashMap<File, Map<String, Object>> map = new HashMap();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        LOGGER.info("Build up HWTransformationCache for 0.8.3");
        HWTransformationCache cache = new HWTransformationCache();
        for (File targetFile : fileDocumentMapping.keySet()) {
            Element oldHWModelElement;
            Document document1 = fileDocumentMapping.get(targetFile);
            if (document1 == null) continue;
            Element rootElement = document1.getRootElement();
            if (rootElement != null && (oldHWModelElement = rootElement.getChild("hwModel")) != null) {
                Object attributeValue;
                Element oldHWSystem = oldHWModelElement.getChild("system");
                if (oldHWSystem != null) {
                    List oldHWQuartzes = oldHWSystem.getChildren("quartzes");
                    for (Element oldHWQuartz : oldHWQuartzes) {
                        attributeValue = oldHWQuartz.getAttributeValue("name");
                        if (attributeValue == null) continue;
                        cache.getOldHwQuartzsMap().put(HelperUtil.encodeName((String)attributeValue), oldHWQuartz);
                    }
                    List oldHWECUs = oldHWSystem.getChildren("ecus");
                    for (Element oldHWECU : oldHWECUs) {
                        List oldHWMicroControllers = oldHWECU.getChildren("microcontrollers");
                        for (Element oldHWMicroController : oldHWMicroControllers) {
                            List oldHWCores = oldHWMicroController.getChildren("cores");
                            for (Element oldHWCore : oldHWCores) {
                                String attributeValue2 = oldHWCore.getAttributeValue("name");
                                if (attributeValue2 == null) continue;
                                cache.getOldCoresMap().put(HelperUtil.encodeName((String)attributeValue2), oldHWCore);
                            }
                        }
                    }
                }
                List oldHWMemoryTypes = oldHWModelElement.getChildren("memoryTypes");
                for (Element oldHWMemoryType : oldHWMemoryTypes) {
                    attributeValue = oldHWMemoryType.getAttributeValue("name");
                    if (attributeValue == null) continue;
                    cache.getOldMemoryTypesDefinitionMap().put(HelperUtil.encodeName((String)attributeValue), oldHWMemoryType);
                }
            }
            HashMap<String, HWTransformationCache> hashMap = new HashMap<String, HWTransformationCache>();
            hashMap.put("globalCache", cache);
            this.map.put(targetFile, hashMap);
        }
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

