/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationInputFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationInputFile.class);
    private String modelVersion = "";
    private boolean isSelectedFile;
    private File file;
    private String projectRelativePath;
    private Document document;
    private boolean isVersionDifferent;

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public boolean isSelectedFile() {
        return this.isSelectedFile;
    }

    public void setSelectedFile(boolean isSelectedFile) {
        this.isSelectedFile = isSelectedFile;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file, File project) {
        this.file = file;
        this.projectRelativePath = project.toURI().relativize(file.toURI()).getPath();
    }

    public String getProjectRelativePath() {
        return this.projectRelativePath;
    }

    public Document getDocument() {
        if (this.document == null) {
            try {
                this.document = HelperUtil.loadFile(this.file.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load model file {}", (Object)this.file.getAbsolutePath(), (Object)e);
            }
        }
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public boolean isVersionDifferent() {
        return this.isVersionDifferent;
    }

    public void setVersionDifferent(boolean isVersionDifferent) {
        this.isVersionDifferent = isVersionDifferent;
    }
}

