/**
 ********************************************************************************
 * Copyright (c) 2015-2019 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */

package org.eclipse.app4mc.amalthea.converters.ui.providers;

import java.io.File;
import java.util.List;

import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.StyledString.Styler;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationInputDataProvider
		extends DelegatingStyledCellLabelProvider
		implements IStructuredContentProvider {

	private static final Logger LOGGER = LoggerFactory.getLogger(MigrationInputDataProvider.class);

	public MigrationInputDataProvider(final IStyledLabelProvider labelProvider) {
		super(labelProvider);
	}

	@Override
	public Object[] getElements(final Object inputElement) {

		if (inputElement instanceof List) {
			return ((List<?>) inputElement).toArray();
		}

		return new Object[] { inputElement };
	}

	@Override
	public StyledString getStyledText(final Object element) {
		if (element instanceof MigrationInputFile) {

			final MigrationInputFile migModelFile = (MigrationInputFile) element;

			final File file = (migModelFile).getFile();
			if (file != null) {

				try {
					// building relative path from the project location

					final String path = migModelFile.getProjectRelativePath();

					if ((migModelFile).isSelectedFile()) {
						return new StyledString(path, new BoldFontStyler());
					}

					return new StyledString(path);
				}
				catch (final Exception e) {

					LOGGER.warn("unable to build the relative path for file : {}", file.getAbsolutePath(), e);

					/*- Displaying the absolute path of the file, as it is not possible to construct relative path*/
					return new StyledString(file.getAbsolutePath());
				}
			}
		}

		return null;
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// empty block
	}

	class BoldFontStyler extends Styler {
		@Override
		public void applyStyles(final TextStyle textStyle) {
			textStyle.foreground = Display.getCurrent().getSystemColor(SWT.COLOR_BLUE);
		}
	}

}
