/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.dialog;

import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.ui.providers.MigrationVersionErrorDataProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class MigrationErrorDialog
extends Dialog {
    private final MigrationSettings migrationSettings;

    public MigrationErrorDialog(Shell parentShell, MigrationSettings migrationSettings) {
        super(parentShell);
        this.setShellStyle(67696);
        this.migrationSettings = migrationSettings;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("AMALTHEA Model Migration");
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("AMALTHEA Model Migration");
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)parentComposite.getLayout();
        gridLayout.numColumns = 1;
        Label lblModelMigrationIs = new Label(parentComposite, 0);
        lblModelMigrationIs.setText("Model migration stopped as selected model files belong to different versions.");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)lblModelMigrationIs);
        Composite tableComposite = this.createFileTableViewer(parentComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        return parentComposite;
    }

    private Composite createFileTableViewer(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewer tableViewer = new TableViewer(tableComposite, 68352);
        tableViewer.setColumnProperties(new String[]{"File Name", "Model Version"});
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn filenameColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = filenameColumn.getColumn();
        column.setText("File Name");
        filenameColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof MigrationInputFile && ((MigrationInputFile)element).isVersionDifferent()) {
                    cell.setForeground(Display.getCurrent().getSystemColor(3));
                }
            }
        });
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(75, true));
        TableViewerColumn modelVersionColumn = new TableViewerColumn(tableViewer, 0);
        column = modelVersionColumn.getColumn();
        column.setText("Model Version");
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(25, true));
        MigrationVersionErrorDataProvider dataProvider = new MigrationVersionErrorDataProvider();
        tableViewer.setContentProvider((IContentProvider)dataProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)dataProvider);
        tableViewer.setInput((Object)this.migrationSettings.getMigModelFiles());
        return tableComposite;
    }
}

