/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.handlers;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters.ui.dialog.MigrationErrorDialog;
import org.eclipse.app4mc.amalthea.converters.ui.dialog.ModelMigrationDialog;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.MigrationJobChangeListener;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelLoaderJob;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelMigrationJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmaltheaModelMigrationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmaltheaModelMigrationHandler.class);
    private static final String SIMPLE_MIGRATION = "simplemigration";

    @Execute
    public void execute(final Shell shell, final @Service MigrationProcessor migrationProcessor, @Named(value="org.eclipse.ui.selection") ISelection selection, final @Optional @Named(value="executioncontext") String executionContext, @Optional @Named(value="migrationversion") String modelEditorVersion) {
        if (selection instanceof TreeSelection) {
            final MigrationSettings migrationSettings = new MigrationSettings();
            ArrayList<File> inputModels = new ArrayList<File>();
            final IProject iProject = this.collectInput((TreeSelection)selection, shell, migrationSettings, inputModels);
            if (modelEditorVersion != null) {
                migrationSettings.setMigrationModelVersion(modelEditorVersion);
            }
            ModelLoaderJob job = new ModelLoaderJob("Parsing selected files to obtain referred AMALTHEA models and corresponding Model versions", migrationSettings, inputModels);
            job.setUser(true);
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(final IJobChangeEvent jobEvent) {
                    super.done(jobEvent);
                    if (jobEvent.getResult().equals(Status.OK_STATUS)) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean inputValid = MigrationHelper.isInputModelVersionValid((MigrationSettings)migrationSettings);
                                    if (!inputValid) {
                                        MigrationErrorDialog errorDialog = new MigrationErrorDialog(shell, migrationSettings);
                                        errorDialog.open();
                                    } else if (migrationSettings.getInputModelVersion() != null && migrationSettings.getInputModelVersion().equals(migrationSettings.getMigrationModelVersion())) {
                                        MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA Model Migration", (String)("Selected models are compatible to latest AMALTHEA meta-model version (" + migrationSettings.getMigrationModelVersion() + ")\nIt is not required to migrate these models !!"));
                                    } else if (!ModelVersion.isValidVersion((String)migrationSettings.getMigrationModelVersion())) {
                                        MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)("The AMALTHEA meta-model version (" + migrationSettings.getMigrationModelVersion() + ") is not supported by the migration component !!"));
                                    } else if (migrationSettings.getInputModelVersion() != null && migrationSettings.getMigrationModelVersion() != null && ModelVersion.getModelVersion((String)migrationSettings.getInputModelVersion()).ordinal() > ModelVersion.getModelVersion((String)migrationSettings.getMigrationModelVersion()).ordinal()) {
                                        MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)("The supported model version (" + migrationSettings.getMigrationModelVersion() + ") is older than the input model version (" + migrationSettings.getInputModelVersion() + ").\n\n" + "A backwards migration is not supported !!"));
                                    } else if (AmaltheaModelMigrationHandler.this.isSimpleMigration(executionContext) && migrationSettings.getMigModelFiles().size() == 1) {
                                        MigrationInputFile migrationInputFile = (MigrationInputFile)migrationSettings.getMigModelFiles().get(0);
                                        migrationSettings.setOutputDirectoryLocation(migrationInputFile.getFile().getParent());
                                        boolean backupSucceeded = MigrationHelper.createBackupFile((MigrationInputFile)migrationInputFile);
                                        if (backupSucceeded) {
                                            ModelMigrationJob migrationJob = new ModelMigrationJob("AMALTHEA Model Migration", migrationProcessor, migrationSettings);
                                            migrationJob.setUser(true);
                                            migrationJob.schedule();
                                            migrationJob.addJobChangeListener((IJobChangeListener)new MigrationJobChangeListener(shell, iProject));
                                        } else {
                                            LOGGER.error("Migration Stopped : Source file could not be backed up before migration");
                                        }
                                    } else {
                                        ModelMigrationDialog dialog = new ModelMigrationDialog(shell, migrationProcessor, migrationSettings, iProject);
                                        dialog.open();
                                    }
                                }
                                catch (MigrationException e) {
                                    MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)e.getLocalizedMessage());
                                }
                            }
                        });
                    } else if (jobEvent.getResult().getCode() == Status.CANCEL_STATUS.getCode()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)jobEvent.getResult().getMessage());
                            }
                        });
                    }
                }
            });
        }
    }

    private IProject collectInput(TreeSelection selection, Shell shell, MigrationSettings settings, List<File> inputModels) {
        TreePath[] paths = selection.getPaths();
        String projectSegment = null;
        IProject iProject = null;
        HashSet<File> inputFiles = new HashSet<File>();
        HashSet<File> parents = new HashSet<File>();
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile;
            Object lastSegment;
            TreePath treePath = treePathArray[n2];
            Object firstSegment = treePath.getFirstSegment();
            if (projectSegment == null) {
                projectSegment = firstSegment.toString();
                iProject = (IProject)((IAdaptable)firstSegment).getAdapter(IProject.class);
                if (iProject != null) {
                    String path = iProject.getLocation().toOSString();
                    File file = new File(path);
                    settings.setProject(file);
                }
            } else if (!projectSegment.equals(firstSegment.toString())) {
                MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)"Model files across the projects should not be selected for migration");
            }
            if ((lastSegment = treePath.getLastSegment()) instanceof IAdaptable && (iFile = (IFile)((IAdaptable)lastSegment).getAdapter(IFile.class)) != null) {
                String path = iFile.getRawLocation().toOSString();
                File file = new File(path);
                try {
                    inputFiles.add(file.getCanonicalFile());
                    parents.add(file.getParentFile());
                }
                catch (IOException e) {
                    LOGGER.error("Error fetching the file : {}", (Object)iFile.toString(), (Object)e);
                }
            }
            ++n2;
        }
        for (File parent : parents) {
            File[] allFilesInDirectory = parent.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    return arg1.endsWith(".amxmi");
                }
            });
            inputFiles.addAll(Arrays.asList(allFilesInDirectory));
        }
        inputModels.addAll(inputFiles);
        return iProject;
    }

    private boolean isSimpleMigration(String context) {
        return context != null && context.equals(SIMPLE_MIGRATION);
    }
}

