/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationJobChangeListener
extends JobChangeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationJobChangeListener.class);
    private Shell shell;
    private IProject project;

    public MigrationJobChangeListener(Shell shell, IProject project) {
        this.shell = shell;
        this.project = project;
    }

    public void done(IJobChangeEvent event) {
        super.done(event);
        IStatus result = event.getResult();
        if (result.getCode() == 20) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)this.shell, (String)"AMALTHEA Model Migration", (String)event.getResult().getMessage()));
        } else if (result.getCode() == 30) {
            Display.getDefault().asyncExec(() -> {
                int n = ErrorDialog.openError((Shell)this.shell, (String)"AMALTHEA Model Migration", (String)event.getResult().getMessage(), (IStatus)event.getResult());
            });
        } else if (result.equals(Status.OK_STATUS)) {
            Display.getDefault().asyncExec(() -> {
                MessageDialog.openInformation((Shell)this.shell, (String)"AMALTHEA Model Migration", (String)"Model Migration successful !!");
                if (this.project != null) {
                    try {
                        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }
}

