/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ModelMigrationJob
extends Job {
    private final MigrationProcessor migrationProcessor;
    private final MigrationSettings migrationSettings;

    public ModelMigrationJob(String name, MigrationProcessor migrationProcessor, MigrationSettings migrationSettings) {
        super(name);
        this.migrationProcessor = migrationProcessor;
        this.migrationSettings = migrationSettings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            int result = this.migrationProcessor.execute(this.migrationSettings, monitor);
            switch (result) {
                case 20: {
                    return new Status(8, "org.eclipse.app4mc.amalthea.converters.ui", 20, "Migration not supported for the selected model versions. \nInput Model version : \"" + this.migrationSettings.getInputModelVersion() + "\" Output Model Version : \"" + this.migrationSettings.getMigrationModelVersion() + "\"", null);
                }
                case 40: {
                    return Status.CANCEL_STATUS;
                }
                case 30: {
                    return new Status(4, "org.eclipse.app4mc.amalthea.converters.ui", 30, "Error during migration", null);
                }
            }
            return Status.OK_STATUS;
        }
        catch (MigrationException e) {
            return new Status(4, "org.eclipse.app4mc.amalthea.converters.ui", 30, "Error during migration", (Throwable)e);
        }
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.equals("AMALTHEA_MODEL_MIGRATION")) {
            return true;
        }
        return super.belongsTo(family);
    }
}

