/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.editors.sirius.design.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.AbstractEventChain;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainContainer;
import org.eclipse.app4mc.amalthea.model.EventChainItem;
import org.eclipse.app4mc.amalthea.model.EventChainItemType;
import org.eclipse.app4mc.amalthea.model.EventChainReference;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEvent;

public class ConstraintService {
    public List<Event> getEventsFromEventChain(AbstractEventChain eventChain) {
        ArrayList<Event> result = new ArrayList<Event>();
        if (eventChain != null) {
            if (eventChain.getStimulus() != null) {
                result.add(eventChain.getStimulus());
            }
            if (!eventChain.getItems().isEmpty() && eventChain.getItemType() == EventChainItemType.SEQUENCE) {
                for (EventChainItem item : eventChain.getItems()) {
                    if (item instanceof EventChainReference) {
                        result.addAll(this.getEventsFromEventChain((AbstractEventChain)((EventChainReference)item).getEventChain()));
                    }
                    if (!(item instanceof EventChainContainer)) continue;
                    result.addAll(this.getEventsFromEventChain((AbstractEventChain)((EventChainContainer)item).getEventChain()));
                }
            }
            if (eventChain.getResponse() != null) {
                result.add(eventChain.getResponse());
            }
        }
        return result;
    }

    public List<Runnable> getRunnablesFromEventChain(EventChain eventChain) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        List<Event> events = this.getEventsFromEventChain((AbstractEventChain)eventChain);
        for (Event event : events) {
            result.addAll(this.getRunnableEdgeForEvent(event));
        }
        return result;
    }

    public List<Runnable> getRunnableEdgeForEvent(Event event) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        if (event instanceof RunnableEvent && ((RunnableEvent)event).getEntity() != null) {
            result.add(((RunnableEvent)event).getEntity());
        }
        return result;
    }

    public String getRunnableEdgeForEventDescription(Event event) {
        if (event instanceof RunnableEvent) {
            return ((RunnableEvent)event).getEventType().getName();
        }
        return null;
    }
}

