/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.actions;

import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.SphinxSupportPlugin;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.editor.ExtendedBasicTransactionalFormEditor;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.messages.Messages;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.ModelHitCollector;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.handlers.SearchDialog;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.handlers.SearchDialogSettings;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SearchAction
extends Action {
    private final ExtendedBasicTransactionalFormEditor editor;

    public SearchAction(ExtendedBasicTransactionalFormEditor editor) {
        super(Messages.SearchAction_title, 1);
        this.editor = editor;
        this.setImageDescriptor(ResourceLocator.imageDescriptorFromBundle((String)SphinxSupportPlugin.getPluginId(), (String)"/icons/full/obj16/find.gif").orElse(null));
        this.setToolTipText(Messages.SearchGUI_title);
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        SearchDialogSettings settings = new SearchDialogSettings();
        IDialogSettings store = SphinxSupportPlugin.getDefault().getDialogSettings();
        settings.loadFrom(store);
        SearchDialog dialog = new SearchDialog(window.getShell(), settings);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            Pattern searchPattern = settings.computeSearchPattern();
            if (searchPattern == null) {
                return;
            }
            settings.saveTo(store);
            Object input = this.editor.getEditorInputObject();
            if (input == null) {
                return;
            }
            EObject model = null;
            if (input instanceof EObject) {
                model = (EObject)input;
            } else if (input instanceof Resource && ((Resource)input).getContents().size() > 0) {
                model = (EObject)((Resource)input).getContents().get(0);
            }
            if (model == null) {
                return;
            }
            ModelHitCollector query = new ModelHitCollector(searchPattern, settings.computeFilterClass(), settings.isSearchRestrictedToFile(), model, this.editor.getEditorInput());
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
    }
}

