/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.hardware;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-HW-Port", checks={"A HwPort can only have one (non internal) HwConnection"})
public class AmHwPort
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getHwPort();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof HwPort) {
            HwPort port = (HwPort)object;
            if (port.isDelegated()) {
                return;
            }
            EList connections = port.getConnections();
            if (connections.size() > 1) {
                int counter = 0;
                for (HwConnection con : connections) {
                    if (con.isInternal()) continue;
                    ++counter;
                }
                if (counter > 1) {
                    this.addIssue(results, (EObject)port, (EStructuralFeature)ePackage.getHwPort_Connections(), "HW Port " + this.qualifiedName((IReferable)port) + ": found " + counter + " connections, only 1 is allowed");
                }
            }
        }
    }
}

