/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.standard;

import javafx.embed.swt.FXCanvas;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.visualizations.standard.util.RunnablePainter;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=LabelAccess View", "description=Graphical representation of Runnable LabelAccess definition"})
public class RunnableVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(Runnable runnable, final Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        FXCanvas fxCanvas = new FXCanvas(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fxCanvas);
        final BorderPane layout = new BorderPane();
        layout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        Scene scene = new Scene((Parent)layout);
        fxCanvas.setScene(scene);
        final RunnablePainter painter = new RunnablePainter(runnable);
        parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                org.eclipse.swt.graphics.Rectangle parentBounds = parent.getBounds();
                Rectangle bounds = new Rectangle(Double.valueOf(parentBounds.x).doubleValue(), Double.valueOf(parentBounds.y).doubleValue(), Double.valueOf(parentBounds.width).doubleValue(), Double.valueOf(parentBounds.height).doubleValue());
                Canvas canvas = new Canvas((double)parentBounds.width, (double)parentBounds.height);
                layout.setCenter((Node)canvas);
                GraphicsContext gc = canvas.getGraphicsContext2D();
                painter.paint(gc, bounds);
            }
        });
    }
}

