/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.standard.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.visualizations.standard.util.RunnablePainter;

public final class RunnableHelper {
    public static double CANVAS_MAX = 6000.0;

    private RunnableHelper() {
    }

    public static double[] calculateGrid(int count) {
        double rows;
        if (count == 3) {
            return new double[]{3.0, 1.0};
        }
        double sqrt = Math.sqrt(count);
        double columns = Math.ceil(sqrt);
        double cells = columns * (rows = Math.max(1.0, Math.floor(sqrt)));
        if (cells < (double)count) {
            rows += 1.0;
        }
        return new double[]{columns, rows};
    }

    public static double[] calculateMinimumCellDimensions(double[] grid, List<RunnablePainter> painter) {
        double minWidth = 0.0;
        double minHeight = 0.0;
        int count = 0;
        RunnablePainter p = null;
        int row = 0;
        while ((double)row < grid[1]) {
            int column = 0;
            while ((double)column < grid[0]) {
                if (count >= painter.size()) break;
                p = painter.get(count);
                minWidth = Math.max(minWidth, p.getPreferredMinimumWidth());
                minHeight = Math.max(minHeight, p.getPreferredMinimumHeight());
                ++count;
                ++column;
            }
            ++row;
        }
        return new double[]{minWidth, minHeight};
    }

    public static List<Runnable> getRunnableDependencies(SWModel swModel, Runnable runnable, boolean collectTransitive) {
        List<Label> readItems = SoftwareUtil.getReadLabelAccessList((Runnable)runnable, null).stream().map(item -> item.getData()).collect(Collectors.toList());
        List<Label> writeItems = SoftwareUtil.getWriteLabelAccessList((Runnable)runnable, null).stream().map(item -> item.getData()).collect(Collectors.toList());
        ArrayList<Runnable> dependencies = new ArrayList<Runnable>();
        RunnableHelper.collectReadDependencies(swModel, readItems, dependencies, collectTransitive);
        Collections.reverse(dependencies);
        dependencies.remove(runnable);
        dependencies.add(runnable);
        RunnableHelper.collectWriteDependencies(swModel, writeItems, dependencies, collectTransitive);
        return dependencies;
    }

    public static void collectReadDependencies(SWModel swModel, List<Label> readItems, List<Runnable> collected, boolean collectTransitive) {
        List<Runnable> directReadDependency = swModel.getRunnables().stream().filter(r -> {
            List wItems = SoftwareUtil.getWriteLabelAccessList((Runnable)r, null).stream().map(item -> item.getData()).collect(Collectors.toList());
            for (Label l : readItems) {
                if (!wItems.contains(l)) continue;
                return true;
            }
            return false;
        }).filter(item -> !collected.contains(item)).collect(Collectors.toList());
        collected.addAll(directReadDependency);
        if (collectTransitive) {
            directReadDependency.forEach(dependency -> {
                List<Label> read = SoftwareUtil.getReadLabelAccessList((Runnable)dependency, null).stream().map(item -> item.getData()).collect(Collectors.toList());
                RunnableHelper.collectReadDependencies(swModel, read, collected, collectTransitive);
            });
        }
    }

    public static void collectWriteDependencies(SWModel swModel, List<Label> writeItems, List<Runnable> collected, boolean collectTransitive) {
        List<Runnable> directWriteDependency = swModel.getRunnables().stream().filter(r -> {
            List rItems = SoftwareUtil.getReadLabelAccessList((Runnable)r, null).stream().map(item -> item.getData()).collect(Collectors.toList());
            for (Label l : writeItems) {
                if (!rItems.contains(l)) continue;
                return true;
            }
            return false;
        }).filter(item -> !collected.contains(item)).collect(Collectors.toList());
        collected.addAll(directWriteDependency);
        if (collectTransitive) {
            directWriteDependency.forEach(dependency -> {
                List<Label> write = SoftwareUtil.getWriteLabelAccessList((Runnable)dependency, null).stream().map(item -> item.getData()).collect(Collectors.toList());
                RunnableHelper.collectWriteDependencies(swModel, write, collected, collectTransitive);
            });
        }
    }

    public static void setMaxScaleFactor(List<RunnablePainter> painter) {
        RunnableHelper.setMaxScaleFactor(painter, RunnableHelper.calculateGrid(painter.size()));
    }

    public static void setMaxScaleFactor(List<RunnablePainter> painter, double[] grid) {
        double[] minDim = RunnableHelper.calculateMinimumCellDimensions(grid, painter);
        double max = Math.max(grid[0] * minDim[0], grid[1] * minDim[1]);
        double factor = CANVAS_MAX / max;
        painter.forEach(p -> p.setMaxScaleFactor(factor));
    }
}

