/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.validation.ui.ProfileDialogSettings;
import org.eclipse.app4mc.validation.ui.provider.ProfileContentProvider;
import org.eclipse.app4mc.validation.ui.provider.ProfileLabelProvider;
import org.eclipse.app4mc.validation.util.CachedProfile;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class ProfileDialog
extends CheckedTreeSelectionDialog {
    private ProfileDialogSettings settings;

    public ProfileDialog(Shell parentShell, ProfileDialogSettings set) {
        this(parentShell, new ProfileLabelProvider(), new ProfileContentProvider(), set);
    }

    public ProfileDialog(Shell parentShell, ILabelProvider labelProvider, ITreeContentProvider contentProvider, ProfileDialogSettings set) {
        super(parentShell, labelProvider, contentProvider);
        this.settings = set != null ? set : new ProfileDialogSettings();
        this.initializeDialog();
    }

    protected void setReturnCode(int code) {
        if (code == 0) {
            this.settings.dialogSuccess = true;
            this.saveDialogResults();
        }
        super.setReturnCode(code);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 300;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        return treeViewer;
    }

    private void initializeDialog() {
        this.setContainerMode(true);
        this.setMessage("Choose profiles");
        this.setTitle("Validations");
        this.setInput(this.settings);
        CachedProfile[] initialSelection = this.settings.getSelectedProfiles();
        this.setInitialElementSelections(Arrays.asList(initialSelection));
        this.setExpandedElements(Arrays.stream(initialSelection).flatMap(cached -> ProfileDialog.getParents(cached).stream()).toArray());
    }

    private void saveDialogResults() {
        Object[] dialogResults = this.getResult();
        if (dialogResults == null) {
            return;
        }
        this.settings.dialogResults = ProfileDialog.filterProfiles(dialogResults).stream().map(cached -> cached.getProfileClass()).collect(Collectors.toList());
    }

    private static List<CachedProfile> filterProfiles(Object[] dialogResults) {
        List<CachedProfile> selectedNodes = Arrays.stream(dialogResults).map(result -> (CachedProfile)result).collect(Collectors.toList());
        HashSet<CachedProfile> nodesToRemove = new HashSet<CachedProfile>();
        for (CachedProfile node : selectedNodes) {
            if (node.getCachedProfiles().isEmpty() || nodesToRemove.contains(node) || !node.getCachedProfiles().values().stream().anyMatch(c -> !selectedNodes.contains(c))) continue;
            nodesToRemove.add(node);
            nodesToRemove.addAll(ProfileDialog.getParents(node));
        }
        for (CachedProfile node : selectedNodes) {
            if (node.getCachedProfiles().isEmpty() || nodesToRemove.contains(node)) continue;
            nodesToRemove.addAll(ProfileDialog.getChildren(node));
        }
        selectedNodes.removeAll(nodesToRemove);
        return selectedNodes;
    }

    private static List<CachedProfile> getParents(CachedProfile node) {
        ArrayList<CachedProfile> list = new ArrayList<CachedProfile>();
        CachedProfile parent = node.getParentProfile();
        while (parent != null) {
            list.add(parent);
            parent = parent.getParentProfile();
        }
        return list;
    }

    private static List<CachedProfile> getChildren(CachedProfile node) {
        ArrayList<CachedProfile> list = new ArrayList<CachedProfile>();
        ProfileDialog.collectChildren(node, list);
        return list;
    }

    private static void collectChildren(CachedProfile node, Collection<CachedProfile> collection) {
        if (!node.getCachedProfiles().isEmpty()) {
            for (CachedProfile child : node.getCachedProfiles().values()) {
                collection.add(child);
                ProfileDialog.collectChildren(child, collection);
            }
        }
    }
}

