/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationHelper.class);
    public static final String UNZIPPED_PREFIX = "unzipped_";
    public static final String INVALID = "invalid";
    public static final String MODEL_FILE_EXTENSION = "amxmi";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private MigrationHelper() {
    }

    public static List<MigrationInputFile> populateModels(List<File> inputModelFiles, MigrationSettings migrationSettings) throws Exception {
        ArrayList<MigrationInputFile> modelFiles = new ArrayList<MigrationInputFile>();
        for (File inputFile : inputModelFiles) {
            MigrationInputFile migModelFile = new MigrationInputFile();
            migModelFile.setFile(inputFile.getCanonicalFile(), migrationSettings.getProject());
            migModelFile.setModelVersion(MigrationHelper.getModelVersion(inputFile));
            modelFiles.add(migModelFile);
        }
        return modelFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveFiles(MigrationSettings settings) throws IOException {
        List<MigrationInputFile> migModelFiles = settings.getMigModelFiles();
        boolean updateFileNames = false;
        if (ModelVersion._103.getVersion().equals(settings.getInputModelVersion()) || ModelVersion._110.getVersion().equals(settings.getInputModelVersion())) {
            List<String> allVersions = ModelVersion.getAllSupportedVersions();
            if (!ModelVersion._103.getVersion().equals(settings.getMigrationModelVersion()) && !ModelVersion._110.getVersion().equals(settings.getMigrationModelVersion()) && allVersions.contains(settings.getMigrationModelVersion())) {
                updateFileNames = true;
            }
        }
        Iterator<MigrationInputFile> iterator = migModelFiles.iterator();
        while (true) {
            Path zipOutputPath;
            Path outputFilePath;
            block19: {
                int indexOfDot;
                String extension;
                String convertedFileName;
                if (!iterator.hasNext()) {
                    return;
                }
                MigrationInputFile inputFile = iterator.next();
                if (inputFile.getDocument() == null) continue;
                String outputDirectoryLocation = settings.getOutputDirectoryLocation();
                String string = convertedFileName = inputFile.getFile() != null ? inputFile.getFile().getName() : inputFile.getOriginalFile().getName();
                if (updateFileNames && (extension = convertedFileName.substring((indexOfDot = convertedFileName.lastIndexOf(".")) + 1)).startsWith(MODEL_FILE_EXTENSION) && !extension.equals(MODEL_FILE_EXTENSION)) {
                    convertedFileName = String.valueOf(convertedFileName) + "." + MODEL_FILE_EXTENSION;
                }
                File outputFile = null;
                Path location = null;
                location = outputDirectoryLocation != null && !outputDirectoryLocation.equals("") ? Paths.get(outputDirectoryLocation, new String[0]) : Paths.get(inputFile.getFile().getParentFile().getAbsolutePath(), new String[0]);
                outputFilePath = Paths.get(location.toString(), convertedFileName);
                HelperUtil.saveFile(inputFile.getDocument(), outputFilePath.toString(), true, true);
                outputFile = outputFilePath.toFile();
                LOGGER.info("Migrated model file saved @ : {}", (Object)outputFile.getAbsolutePath());
                if (!inputFile.isZipFile()) continue;
                zipOutputPath = Paths.get(location.toString(), inputFile.getOriginalFile().getName());
                Throwable throwable = null;
                Object var12_14 = null;
                try {
                    ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(zipOutputPath, new OpenOption[0]));
                    try {
                        try (InputStream fis = Files.newInputStream(outputFilePath, new OpenOption[0]);){
                            int length;
                            ZipEntry zipEntry = new ZipEntry(inputFile.getOriginalFile().getName());
                            zipOut.putNextEntry(zipEntry);
                            byte[] bytes = new byte[1024];
                            while ((length = fis.read(bytes)) >= 0) {
                                zipOut.write(bytes, 0, length);
                            }
                        }
                        if (zipOut == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (zipOut == null) throw throwable;
                        zipOut.close();
                        throw throwable;
                    }
                    zipOut.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            LOGGER.info("Created archive model file @ : {}", (Object)zipOutputPath);
            Files.delete(outputFilePath);
        }
    }

    public static Map<String, String> generateMigrationSteps(String inputModelVersion, String outputModelVersion) {
        LinkedHashMap<String, String> migStepEntries = new LinkedHashMap<String, String>();
        List<String> versions = ModelVersion.getAllSupportedVersions();
        int inputModelVersionIndex = versions.indexOf(inputModelVersion);
        int outputModelVersionIndex = versions.indexOf(outputModelVersion);
        if (inputModelVersionIndex != -1 && outputModelVersionIndex != -1) {
            int i = inputModelVersionIndex;
            while (i <= outputModelVersionIndex && i + 1 <= outputModelVersionIndex) {
                migStepEntries.put(versions.get(i), versions.get(i + 1));
                ++i;
            }
        }
        return migStepEntries;
    }

    public static boolean isInputModelVersionValid(MigrationSettings migrationSettings) {
        List<MigrationInputFile> modelsWithLegacyVersionInfo = MigrationHelper.getInputModelsOfLegacyVersions(migrationSettings);
        List<MigrationInputFile> modelsWithInvalidVersionInfo = MigrationHelper.getModelsWithInvalidVersionInfo(migrationSettings);
        if (!modelsWithLegacyVersionInfo.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Can not migrate legacy Amalthea models of versions : itea.103 or itea.110 or itea.111");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("From APP4MC 0.9.3, support for migrating legacy model versions (itea.103, itea.110, itea.111) is removed");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("** Legacy model versions found for the below files ->");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            for (MigrationInputFile migrationFile : modelsWithInvalidVersionInfo) {
                builder.append(migrationFile.getOriginalFile().getAbsolutePath()).append(" Version: ").append(migrationFile.getModelVersion());
                builder.append(LINE_SEPARATOR);
                builder.append(" -------- > Version: ").append(migrationFile.getModelVersion());
            }
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("Use one of the previous version of APP4MC (till 0.9.2) for migrating these legacy Amalthea models to regular versions (0.7.0 and above)");
            throw new MigrationException(builder.toString());
        }
        if (!modelsWithInvalidVersionInfo.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Invalid model versions found for the below files ->");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            for (MigrationInputFile migrationFile : modelsWithInvalidVersionInfo) {
                builder.append(migrationFile.getOriginalFile().getAbsolutePath());
                builder.append(LINE_SEPARATOR);
            }
            throw new MigrationException(builder.toString());
        }
        boolean inputModelVersionEqual = true;
        String inputModelVersion = null;
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            if (inputModelVersion == null) {
                inputModelVersion = migModelFile.getModelVersion();
                continue;
            }
            if (inputModelVersion.equals(migModelFile.getModelVersion())) continue;
            migModelFile.setVersionDifferent(true);
            inputModelVersionEqual = false;
        }
        if (inputModelVersionEqual) {
            migrationSettings.setInputModelVersion(inputModelVersion);
        }
        return inputModelVersionEqual;
    }

    private static List<MigrationInputFile> getInputModelsOfLegacyVersions(MigrationSettings migrationSettings) {
        ArrayList<MigrationInputFile> list = new ArrayList<MigrationInputFile>();
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            String inputModelVersion = migModelFile.getModelVersion();
            if (inputModelVersion == null || !inputModelVersion.equals(ModelVersion._103.getVersion()) && !inputModelVersion.equals(ModelVersion._110.getVersion()) && !inputModelVersion.equals(ModelVersion._111.getVersion())) continue;
            list.add(migModelFile);
        }
        return list;
    }

    private static List<MigrationInputFile> getModelsWithInvalidVersionInfo(MigrationSettings migrationSettings) {
        ArrayList<MigrationInputFile> list = new ArrayList<MigrationInputFile>();
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            String inputModelVersion = migModelFile.getModelVersion();
            if (ModelVersion.isValidVersion(inputModelVersion)) continue;
            list.add(migModelFile);
        }
        return list;
    }

    public static boolean createBackupFile(MigrationInputFile migrationInputFile) {
        String newFileName = MigrationHelper.getBackupFileName(migrationInputFile);
        try {
            String filebackupName = String.valueOf(migrationInputFile.getOriginalFile().getParent()) + File.separator + newFileName;
            Files.copy(migrationInputFile.getOriginalFile().toPath(), new File(filebackupName).toPath(), StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Original model file saved as {}", (Object)filebackupName);
            if (new File(filebackupName).exists()) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static String getBackupFileName(MigrationInputFile migrationInputFile) {
        String fileName = migrationInputFile.getOriginalFile().getName();
        String newFileName = fileName.substring(0, fileName.lastIndexOf(46));
        String suffixString = "_" + migrationInputFile.getModelVersion();
        String fileExtension = ".amxmi";
        newFileName = String.valueOf(newFileName) + suffixString + fileExtension;
        if (new File(String.valueOf(migrationInputFile.getOriginalFile().getParent()) + File.separator + newFileName).exists()) {
            newFileName = newFileName.replace(String.valueOf(suffixString) + fileExtension, String.valueOf(suffixString) + suffixString + fileExtension);
        }
        return newFileName;
    }

    public static String getModelVersion(File inputModelFile) {
        String result = INVALID;
        if (inputModelFile != null && inputModelFile.exists() && inputModelFile.getName().endsWith(MODEL_FILE_EXTENSION)) {
            Path inputPath = Paths.get(inputModelFile.toURI());
            result = MigrationHelper.isZipFile(inputModelFile) ? MigrationHelper.getModelVersionFromZip(inputPath) : MigrationHelper.getModelVersionFromFile(inputPath);
        }
        return result;
    }

    public static String getModelVersionFromFile(Path inputPath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream input = Files.newInputStream(inputPath, new OpenOption[0]);){
                return MigrationHelper.getModelVersion(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XMLStreamException e) {
            LOGGER.error("Error on parsing input model file for model version", (Throwable)e);
            return INVALID;
        }
    }

    public static String getModelVersionFromZip(Path inputPath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ZipInputStream input = new ZipInputStream(Files.newInputStream(inputPath, new OpenOption[0]));){
                ZipEntry zipEntry = input.getNextEntry();
                if (zipEntry != null) {
                    return MigrationHelper.getModelVersion(input);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XMLStreamException e) {
            LOGGER.error("Error on parsing input model file for model version", (Throwable)e);
        }
        return INVALID;
    }

    private static String getModelVersion(InputStream input) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        XMLEventReader reader = xmlInputFactory.createXMLEventReader(input);
        while (reader.hasNext()) {
            StartElement startElement;
            XMLEvent nextEvent = reader.nextEvent();
            if (!nextEvent.isStartElement() || !"am".equals((startElement = nextEvent.asStartElement()).getName().getPrefix())) continue;
            String url = startElement.getNamespaceURI("am");
            Namespace namespace = Namespace.getNamespace((String)"am", (String)url);
            ModelVersion version = AmaltheaNamespaceRegistry.getModelVersion(namespace);
            if (version == null) break;
            return version.getVersion();
        }
        return INVALID;
    }

    public static boolean isZipFile(File file) {
        boolean result = false;
        if (file != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ZipFile f = new ZipFile(file);){
                    result = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static File temporaryUnzip(File input) throws IOException {
        Path inputPath = Paths.get(input.toURI());
        byte[] buffer = new byte[1024];
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(inputPath, new OpenOption[0]));){
            ZipEntry zipEntry = zis.getNextEntry();
            Path unzipped = Paths.get(inputPath.getParent().toString(), UNZIPPED_PREFIX + zipEntry.getName());
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (OutputStream fos = Files.newOutputStream(unzipped, new OpenOption[0]);){
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            zis.closeEntry();
            return unzipped.toFile();
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static boolean isModelFile(String filename) {
        String fileExtension = filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
        return MigrationHelper.isModelFileExtension(fileExtension);
    }

    public static boolean isModelFileExtension(String fileExtension) {
        return MODEL_FILE_EXTENSION.equals(fileExtension);
    }
}

