/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.handlers;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.Evaluate;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmaltheaResourceExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmaltheaResourceExpression.class);

    @Evaluate
    public boolean evaluate(@Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty() && selection.size() == 1 && selection.getFirstElement() instanceof IResource) {
            IResource resource = (IResource)selection.getFirstElement();
            if (resource instanceof IFile && MigrationHelper.isModelFileExtension((String)resource.getFileExtension())) {
                return true;
            }
            if (resource instanceof IContainer) {
                IContainer folder = (IContainer)resource;
                Path modelFilePath = Paths.get(folder.getLocationURI());
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (Stream<Path> directoryStream = Files.walk(modelFilePath, Integer.MAX_VALUE, new FileVisitOption[0]);){
                        return directoryStream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).anyMatch(file -> MigrationHelper.isModelFile((String)file.toString()));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to collect model files", (Throwable)e);
                }
            }
        }
        return false;
    }
}

