/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.provider;

import com.google.common.base.Objects;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueBoundaries;
import org.eclipse.app4mc.amalthea.model.ContinuousValueConstant;
import org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.ContinuousValueInterval;
import org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics;
import org.eclipse.app4mc.amalthea.model.ContinuousValueUniformDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueBoundaries;
import org.eclipse.app4mc.amalthea.model.DiscreteValueConstant;
import org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram;
import org.eclipse.app4mc.amalthea.model.DiscreteValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.DiscreteValueInterval;
import org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics;
import org.eclipse.app4mc.amalthea.model.DiscreteValueUniformDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeBetaDistribution;
import org.eclipse.app4mc.amalthea.model.TimeBoundaries;
import org.eclipse.app4mc.amalthea.model.TimeConstant;
import org.eclipse.app4mc.amalthea.model.TimeGaussDistribution;
import org.eclipse.app4mc.amalthea.model.TimeHistogram;
import org.eclipse.app4mc.amalthea.model.TimeHistogramEntry;
import org.eclipse.app4mc.amalthea.model.TimeInterval;
import org.eclipse.app4mc.amalthea.model.TimeStatistics;
import org.eclipse.app4mc.amalthea.model.TimeUniformDistribution;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class CustomDeviationItemProviderService {
    private static final String DIAMETER = "\u2300";
    private static final String INFINITY = "\u221e";
    private static final String UNKNOWN = "???";
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");

    private static String getContainingFeatureName(EObject object, String defaultText, String separator) {
        boolean _endsWith;
        EStructuralFeature _eContainingFeature = null;
        if (object != null) {
            _eContainingFeature = object.eContainingFeature();
        }
        EStructuralFeature feature = _eContainingFeature;
        String _xifexpression = null;
        _xifexpression = feature == null ? defaultText : feature.getName();
        String name = _xifexpression;
        if (object instanceof IDiscreteValueDeviation && (_endsWith = name.endsWith("Latency"))) {
            name = String.valueOf(name) + " [cycles]";
        }
        return String.valueOf(name) + separator;
    }

    private static String getContainingFeatureName(EObject object) {
        return CustomDeviationItemProviderService.getContainingFeatureName(object, "", ": ");
    }

    private static void addParentLabelNotification(List<ViewerNotification> list, Notification notification) {
        CustomDeviationItemProviderService.addParentLabelNotification(list, notification, 1);
    }

    private static void addParentLabelNotification(List<ViewerNotification> list, Notification notification, int number) {
        Object _notifier = notification.getNotifier();
        EObject obj = (EObject)_notifier;
        int i = 0;
        while (++i <= number && (obj = obj.eContainer()) != null) {
            ViewerNotification _viewerNotification = new ViewerNotification(notification, (Object)obj, false, true);
            list.add(0, _viewerNotification);
        }
    }

    private static String intervalText(Object min, Object max) {
        return CustomDeviationItemProviderService.intervalText(min, max, false);
    }

    private static String intervalText(Object min, Object max, boolean infinity) {
        String _xifexpression = null;
        _xifexpression = infinity ? "-\u221e" : UNKNOWN;
        String NO_MIN = _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = infinity ? INFINITY : UNKNOWN;
        String NO_MAX = _xifexpression_1;
        String _xifexpression_2 = null;
        _xifexpression_2 = min == null ? NO_MIN : min.toString();
        String s1 = _xifexpression_2;
        String _xifexpression_3 = null;
        _xifexpression_3 = max == null ? NO_MAX : max.toString();
        String s2 = _xifexpression_3;
        return " [" + s1 + ", " + s2 + "]";
    }

    private static String averageText(Object avg) {
        if (avg == null) {
            return "";
        }
        if (avg instanceof Time) {
            boolean _tripleEquals;
            BigInteger _value = ((Time)avg).getValue();
            boolean bl = _tripleEquals = _value == null;
            if (_tripleEquals) {
                return "";
            }
            TimeUnit _unit = ((Time)avg).getUnit();
            boolean _equals = Objects.equal((Object)_unit, (Object)TimeUnit._UNDEFINED_);
            if (_equals) {
                return "";
            }
        }
        String _switchResult = null;
        boolean _matched = false;
        if (avg instanceof Double) {
            _matched = true;
            _switchResult = FORMAT.format(avg);
        }
        if (!_matched && avg instanceof Float) {
            _matched = true;
            _switchResult = FORMAT.format(avg);
        }
        if (!_matched && avg instanceof Time) {
            _matched = true;
            _switchResult = ((Time)avg).adjustUnit().toString();
        }
        if (!_matched) {
            _switchResult = avg.toString();
        }
        String avgText = _switchResult;
        return " \u2300 " + avgText;
    }

    private static String constantText(Object value) {
        String _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = value == null ? UNKNOWN : value.toString();
        String s1 = _xifexpression;
        _xblockexpression = "Constant {" + s1 + "}";
        return _xblockexpression;
    }

    private static String boundariesText(Object min, Object max) {
        String _intervalText = CustomDeviationItemProviderService.intervalText(min, max);
        return "Boundaries" + _intervalText;
    }

    private static String uniformText(Object min, Object max) {
        String _intervalText = CustomDeviationItemProviderService.intervalText(min, max);
        return "Uniform" + _intervalText;
    }

    private static String statisticsText(Object min, Object avg, Object max) {
        String _intervalText = CustomDeviationItemProviderService.intervalText(min, max);
        String _plus = "Statistics" + _intervalText;
        String _averageText = CustomDeviationItemProviderService.averageText(avg);
        return String.valueOf(_plus) + _averageText;
    }

    private static String gaussText(Object min, Object avg, Object max) {
        String _averageText = CustomDeviationItemProviderService.averageText(avg);
        String _plus = "Gauss" + _averageText;
        String _intervalText = CustomDeviationItemProviderService.intervalText(min, max, true);
        return String.valueOf(_plus) + _intervalText;
    }

    private static String betaText(Object min, Object avg, Object max) {
        String _averageText = CustomDeviationItemProviderService.averageText(avg);
        String _plus = "Beta" + _averageText;
        String _intervalText = CustomDeviationItemProviderService.intervalText(min, max);
        return String.valueOf(_plus) + _intervalText;
    }

    private static String histogramText(Object min, Object avg, Object max) {
        String _averageText = CustomDeviationItemProviderService.averageText(avg);
        String _plus = "Histogram" + _averageText;
        String _intervalText = CustomDeviationItemProviderService.intervalText(min, max);
        return String.valueOf(_plus) + _intervalText;
    }

    private static String weibullText(Object min, Object avg, Object max) {
        String _averageText = CustomDeviationItemProviderService.averageText(avg);
        String _plus = "Weibull" + _averageText;
        String _intervalText = CustomDeviationItemProviderService.intervalText(min, max);
        return String.valueOf(_plus) + _intervalText;
    }

    public static String deviationText(Object dev) {
        String _switchResult = null;
        boolean _matched = false;
        if (dev instanceof ContinuousValueConstant) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.constantText(((ContinuousValueConstant)dev).getValue());
        }
        if (!_matched && dev instanceof DiscreteValueConstant) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.constantText(((DiscreteValueConstant)dev).getValue());
        }
        if (!_matched && dev instanceof TimeConstant) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.constantText(((TimeConstant)dev).getValue());
        }
        if (!_matched && dev instanceof ContinuousValueBoundaries) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.boundariesText(((ContinuousValueBoundaries)dev).getLowerBound(), ((ContinuousValueBoundaries)dev).getUpperBound());
        }
        if (!_matched && dev instanceof DiscreteValueBoundaries) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.boundariesText(((DiscreteValueBoundaries)dev).getLowerBound(), ((DiscreteValueBoundaries)dev).getUpperBound());
        }
        if (!_matched && dev instanceof TimeBoundaries) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.boundariesText(((TimeBoundaries)dev).getLowerBound(), ((TimeBoundaries)dev).getUpperBound());
        }
        if (!_matched && dev instanceof ContinuousValueUniformDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.uniformText(((ContinuousValueUniformDistribution)dev).getLowerBound(), ((ContinuousValueUniformDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof DiscreteValueUniformDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.uniformText(((DiscreteValueUniformDistribution)dev).getLowerBound(), ((DiscreteValueUniformDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof TimeUniformDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.uniformText(((TimeUniformDistribution)dev).getLowerBound(), ((TimeUniformDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof ContinuousValueStatistics) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.statisticsText(((ContinuousValueStatistics)dev).getLowerBound(), ((ContinuousValueStatistics)dev).getAverage(), ((ContinuousValueStatistics)dev).getUpperBound());
        }
        if (!_matched && dev instanceof DiscreteValueStatistics) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.statisticsText(((DiscreteValueStatistics)dev).getLowerBound(), ((DiscreteValueStatistics)dev).getAverage(), ((DiscreteValueStatistics)dev).getUpperBound());
        }
        if (!_matched && dev instanceof TimeStatistics) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.statisticsText(((TimeStatistics)dev).getLowerBound(), ((TimeStatistics)dev).getAverage(), ((TimeStatistics)dev).getUpperBound());
        }
        if (!_matched && dev instanceof ContinuousValueGaussDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.gaussText(((ContinuousValueGaussDistribution)dev).getLowerBound(), ((ContinuousValueGaussDistribution)dev).getAverage(), ((ContinuousValueGaussDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof DiscreteValueGaussDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.gaussText(((DiscreteValueGaussDistribution)dev).getLowerBound(), ((DiscreteValueGaussDistribution)dev).getAverage(), ((DiscreteValueGaussDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof TimeGaussDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.gaussText(((TimeGaussDistribution)dev).getLowerBound(), ((TimeGaussDistribution)dev).getAverage(), ((TimeGaussDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof ContinuousValueBetaDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.betaText(((ContinuousValueBetaDistribution)dev).getLowerBound(), ((ContinuousValueBetaDistribution)dev).getAverage(), ((ContinuousValueBetaDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof DiscreteValueBetaDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.betaText(((DiscreteValueBetaDistribution)dev).getLowerBound(), ((DiscreteValueBetaDistribution)dev).getAverage(), ((DiscreteValueBetaDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof TimeBetaDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.betaText(((TimeBetaDistribution)dev).getLowerBound(), ((TimeBetaDistribution)dev).getAverage(), ((TimeBetaDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof ContinuousValueHistogram) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.histogramText(((ContinuousValueHistogram)dev).getLowerBound(), ((ContinuousValueHistogram)dev).getAverage(), ((ContinuousValueHistogram)dev).getUpperBound());
        }
        if (!_matched && dev instanceof DiscreteValueHistogram) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.histogramText(((DiscreteValueHistogram)dev).getLowerBound(), ((DiscreteValueHistogram)dev).getAverage(), ((DiscreteValueHistogram)dev).getUpperBound());
        }
        if (!_matched && dev instanceof TimeHistogram) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.histogramText(((TimeHistogram)dev).getLowerBound(), ((TimeHistogram)dev).getAverage(), ((TimeHistogram)dev).getUpperBound());
        }
        if (!_matched && dev instanceof ContinuousValueWeibullEstimatorsDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.weibullText(((ContinuousValueWeibullEstimatorsDistribution)dev).getLowerBound(), ((ContinuousValueWeibullEstimatorsDistribution)dev).getAverage(), ((ContinuousValueWeibullEstimatorsDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof DiscreteValueWeibullEstimatorsDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.weibullText(((DiscreteValueWeibullEstimatorsDistribution)dev).getLowerBound(), ((DiscreteValueWeibullEstimatorsDistribution)dev).getAverage(), ((DiscreteValueWeibullEstimatorsDistribution)dev).getUpperBound());
        }
        if (!_matched && dev instanceof TimeWeibullEstimatorsDistribution) {
            _matched = true;
            _switchResult = CustomDeviationItemProviderService.weibullText(((TimeWeibullEstimatorsDistribution)dev).getLowerBound(), ((TimeWeibullEstimatorsDistribution)dev).getAverage(), ((TimeWeibullEstimatorsDistribution)dev).getUpperBound());
        }
        if (!_matched) {
            _switchResult = "<undefined deviation>";
        }
        return _switchResult;
    }

    public static String getContinuousValueConstantItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueConstant) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getContinuousValueConstantItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueConstant.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getContinuousValueGaussDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueGaussDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getContinuousValueGaussDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueGaussDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getContinuousValueHistogramItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueHistogram) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getContinuousValueHistogramItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueHistogramEntry.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, true, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getContinuousValueHistogramEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueHistogramEntry) {
            long num = ((ContinuousValueHistogramEntry)object).getOccurrences();
            String _intervalText = CustomDeviationItemProviderService.intervalText(((ContinuousValueHistogramEntry)object).getLowerBound(), ((ContinuousValueHistogramEntry)object).getUpperBound());
            return "Entry -- " + Long.valueOf(num) + " x " + _intervalText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getContinuousValueHistogramEntryItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueHistogramEntry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification, 2);
        }
        return list;
    }

    public static List<ViewerNotification> getContinuousValueIntervalItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueInterval.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getContinuousValueBetaDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueBetaDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getContinuousValueBetaDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueBetaDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getContinuousValueBoundariesItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueBoundaries) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getContinuousValueBoundariesItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueBoundaries.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getContinuousValueStatisticsItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueStatistics) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getContinuousValueStatisticsItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueStatistics.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getContinuousValueUniformDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueUniformDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static String getContinuousValueWeibullEstimatorsDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof ContinuousValueWeibullEstimatorsDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getContinuousValueWeibullEstimatorsDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(ContinuousValueWeibullEstimatorsDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDiscreteValueConstantItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueConstant) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDiscreteValueConstantItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueConstant.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDiscreteValueGaussDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueGaussDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDiscreteValueGaussDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueGaussDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDiscreteValueHistogramItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueHistogram) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDiscreteValueHistogramItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueHistogramEntry.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, true, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDiscreteValueHistogramEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueHistogramEntry) {
            long num = ((DiscreteValueHistogramEntry)object).getOccurrences();
            String _intervalText = CustomDeviationItemProviderService.intervalText(((DiscreteValueHistogramEntry)object).getLowerBound(), ((DiscreteValueHistogramEntry)object).getUpperBound());
            return "Entry -- " + Long.valueOf(num) + " x " + _intervalText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDiscreteValueHistogramEntryItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueHistogramEntry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification, 2);
        }
        return list;
    }

    public static List<ViewerNotification> getDiscreteValueIntervalItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueInterval.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDiscreteValueBetaDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueBetaDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDiscreteValueBetaDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueBetaDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDiscreteValueBoundariesItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueBoundaries) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDiscreteValueBoundariesItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueBoundaries.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDiscreteValueStatisticsItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueStatistics) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDiscreteValueStatisticsItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueStatistics.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getDiscreteValueUniformDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueUniformDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static String getDiscreteValueWeibullEstimatorsDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof DiscreteValueWeibullEstimatorsDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getDiscreteValueWeibullEstimatorsDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(DiscreteValueWeibullEstimatorsDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getTimeConstantItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeConstant) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeConstantItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeConstant.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getTimeGaussDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeGaussDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeGaussDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeGaussDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, true, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getTimeHistogramItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeHistogram) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeHistogramItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeHistogram.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, true, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getTimeHistogramEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeHistogramEntry) {
            long num = ((TimeHistogramEntry)object).getOccurrences();
            String _intervalText = CustomDeviationItemProviderService.intervalText(((TimeHistogramEntry)object).getLowerBound(), ((TimeHistogramEntry)object).getUpperBound());
            return "Entry -- " + Long.valueOf(num) + " x " + _intervalText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeHistogramEntryItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeHistogramEntry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, true, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification, 2);
        }
        return list;
    }

    public static List<ViewerNotification> getTimeIntervalItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeInterval.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, true, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getTimeBetaDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeBetaDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeBetaDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeBetaDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getTimeBoundariesItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeBoundaries) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeBoundariesItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeBoundaries.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getTimeStatisticsItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeStatistics) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeStatisticsItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeStatistics.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, true, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }

    public static String getTimeUniformDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeUniformDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static String getTimeWeibullEstimatorsDistributionItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeWeibullEstimatorsDistribution) {
            String _containingFeatureName = CustomDeviationItemProviderService.getContainingFeatureName((EObject)object);
            String _deviationText = CustomDeviationItemProviderService.deviationText(object);
            return String.valueOf(_containingFeatureName) + _deviationText;
        }
        return defaultText;
    }

    public static List<ViewerNotification> getTimeWeibullEstimatorsDistributionItemProviderNotifications(Notification notification) {
        ArrayList list = CollectionLiterals.newArrayList();
        int _featureID = notification.getFeatureID(TimeWeibullEstimatorsDistribution.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            ViewerNotification _viewerNotification = new ViewerNotification(notification, _notifier, false, true);
            list.add(_viewerNotification);
            CustomDeviationItemProviderService.addParentLabelNotification(list, notification);
        }
        return list;
    }
}

