/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.LimitType;
import org.eclipse.app4mc.amalthea.model.ProcessRequirement;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableRequirement;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeMetric;
import org.eclipse.app4mc.amalthea.model.TimeRequirementLimit;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ConstraintsUtil {
    private static final String ARG_NULL_MESSAGE = "Argument is null";

    private ConstraintsUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static @Nullable Time getDeadline(@NonNull AbstractProcess process) {
        Preconditions.checkArgument((process != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        ConstraintsModel constraintsModel = ConstraintsUtil.getConstraintsModel(process);
        if (constraintsModel == null) {
            return null;
        }
        return ConstraintsUtil.getDeadline(process, constraintsModel);
    }

    public static @Nullable Time getDeadline(@NonNull AbstractProcess process, @NonNull ConstraintsModel constModel) {
        Preconditions.checkArgument((process != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((constModel != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        List list = ConstraintsUtil.getDeadlineRequirements(process, constModel).stream().map(req -> ((TimeRequirementLimit)req.getLimit()).getLimitValue()).filter(Objects::nonNull).sorted(Time::compareTo).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (Time)list.get(0);
    }

    public static @Nullable Time getDeadline(@NonNull Runnable runnable) {
        Preconditions.checkArgument((runnable != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        ConstraintsModel constraintsModel = ConstraintsUtil.getConstraintsModel(runnable);
        if (constraintsModel == null) {
            return null;
        }
        return ConstraintsUtil.getDeadline(runnable, constraintsModel);
    }

    public static @Nullable Time getDeadline(@NonNull Runnable runnable, @NonNull ConstraintsModel constModel) {
        Preconditions.checkArgument((runnable != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((constModel != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        List list = ConstraintsUtil.getDeadlineRequirements(runnable, constModel).stream().map(req -> ((TimeRequirementLimit)req.getLimit()).getLimitValue()).filter(Objects::nonNull).sorted(Time::compareTo).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (Time)list.get(0);
    }

    public static void addNewDeadlineRequirement(@NonNull ConstraintsModel container, @NonNull AbstractProcess process, @NonNull Time deadline) {
        Preconditions.checkArgument((container != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((process != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((deadline != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        limit.setMetric(TimeMetric.RESPONSE_TIME);
        limit.setLimitType(LimitType.UPPER_LIMIT);
        limit.setLimitValue(deadline);
        ProcessRequirement req = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        req.setName("Process deadline");
        req.setProcess(process);
        req.setLimit(limit);
        container.getRequirements().add((Object)req);
    }

    public static void addNewDeadlineRequirement(@NonNull ConstraintsModel container, @NonNull Runnable runnable, @NonNull Time deadline) {
        Preconditions.checkArgument((container != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((runnable != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((deadline != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        limit.setMetric(TimeMetric.RESPONSE_TIME);
        limit.setLimitType(LimitType.UPPER_LIMIT);
        limit.setLimitValue(deadline);
        RunnableRequirement req = AmaltheaFactory.eINSTANCE.createRunnableRequirement();
        req.setName("Runnable deadline");
        req.setRunnable(runnable);
        req.setLimit(limit);
        container.getRequirements().add((Object)req);
    }

    public static void updateDeadlineRequirement(@NonNull Task task, @NonNull Time deadline) {
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((deadline != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        ConstraintsModel constraintsModel = ConstraintsUtil.getConstraintsModel(task);
        if (constraintsModel == null) {
            return;
        }
        ConstraintsUtil.updateDeadlineRequirement(task, deadline, constraintsModel);
    }

    public static void updateDeadlineRequirement(@NonNull Task task, @NonNull Time deadline, @NonNull ConstraintsModel constModel) {
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((deadline != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((constModel != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        List<ProcessRequirement> requirements = ConstraintsUtil.getDeadlineRequirements(task, constModel);
        if (requirements.isEmpty()) {
            ConstraintsUtil.addNewDeadlineRequirement(constModel, task, deadline);
        } else {
            ProcessRequirement first = requirements.remove(0);
            ((TimeRequirementLimit)first.getLimit()).setLimitValue(deadline);
            AmaltheaIndex.deleteAll(requirements);
        }
    }

    public static void updateDeadlineRequirement(@NonNull Runnable runnable, @NonNull Time deadline) {
        Preconditions.checkArgument((runnable != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((deadline != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        ConstraintsModel constraintsModel = ConstraintsUtil.getConstraintsModel(runnable);
        if (constraintsModel == null) {
            return;
        }
        ConstraintsUtil.updateDeadlineRequirement(runnable, deadline, constraintsModel);
    }

    public static void updateDeadlineRequirement(@NonNull Runnable runnable, @NonNull Time deadline, @NonNull ConstraintsModel constModel) {
        Preconditions.checkArgument((runnable != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((deadline != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((constModel != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        List<RunnableRequirement> requirements = ConstraintsUtil.getDeadlineRequirements(runnable, constModel);
        if (requirements.isEmpty()) {
            ConstraintsUtil.addNewDeadlineRequirement(constModel, runnable, deadline);
        } else {
            RunnableRequirement first = requirements.remove(0);
            ((TimeRequirementLimit)first.getLimit()).setLimitValue(deadline);
            AmaltheaIndex.deleteAll(requirements);
        }
    }

    public static List<RunnableRequirement> getDeadlineRequirements(@NonNull Runnable runnable, @NonNull ConstraintsModel constModel) {
        Preconditions.checkArgument((runnable != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((constModel != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        return constModel.getRequirements().stream().filter(req -> req.getLimit().getLimitType() == LimitType.UPPER_LIMIT && req instanceof RunnableRequirement && ((RunnableRequirement)req).getRunnable() == runnable && req.getLimit() instanceof TimeRequirementLimit && ((TimeRequirementLimit)req.getLimit()).getMetric() == TimeMetric.RESPONSE_TIME).map(req -> (RunnableRequirement)req).collect(Collectors.toList());
    }

    public static List<ProcessRequirement> getDeadlineRequirements(@NonNull AbstractProcess process, @NonNull ConstraintsModel constModel) {
        Preconditions.checkArgument((process != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Preconditions.checkArgument((constModel != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        return constModel.getRequirements().stream().filter(req -> req.getLimit().getLimitType() == LimitType.UPPER_LIMIT && req instanceof ProcessRequirement && ((ProcessRequirement)req).getProcess() == process && req.getLimit() instanceof TimeRequirementLimit && ((TimeRequirementLimit)req.getLimit()).getMetric() == TimeMetric.RESPONSE_TIME).map(req -> (ProcessRequirement)req).collect(Collectors.toList());
    }

    private static ConstraintsModel getConstraintsModel(@NonNull EObject object) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG_NULL_MESSAGE);
        Amalthea modelRoot = AmaltheaServices.getContainerOfType(object, Amalthea.class);
        if (modelRoot == null) {
            return null;
        }
        return ModelUtil.getOrCreateConstraintsModel(modelRoot);
    }
}

