/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveStimulus;
import org.eclipse.app4mc.amalthea.model.CustomStimulus;
import org.eclipse.app4mc.amalthea.model.EventStimulus;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.ITimeDeviation;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.PeriodicSyntheticStimulus;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.RelativePeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.VariableRateStimulus;
import org.eclipse.app4mc.amalthea.model.util.DeploymentUtil;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class RuntimeUtil {
    private RuntimeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Time getExecutionTimeForProcess(Process process, EMap<ModeLabel, String> modes, TimeType executionCase) {
        Time result = FactoryUtil.createTime();
        Set<ProcessingUnit> processingUnits = DeploymentUtil.getAssignedCoreForProcess(process, (Amalthea)process.eContainer().eContainer());
        List<Runnable> runnables = SoftwareUtil.getRunnableList(process, modes);
        if (processingUnits.size() == 1) {
            ProcessingUnit processingUnit = processingUnits.iterator().next();
            for (Runnable runnable : runnables) {
                result = result.add(RuntimeUtil.getExecutionTimeForRunnable(runnable, processingUnit, modes, executionCase));
            }
        } else {
            System.out.println("Mapping unclear. Process mapped to " + processingUnits.size() + " Cores - Use PU specific method");
        }
        return result;
    }

    public static Time getExecutionTimeForProcess(Process process, ProcessingUnit processingUnit, EMap<ModeLabel, String> modes, TimeType executionCase) {
        Time result = FactoryUtil.createTime();
        List<Runnable> runnables = SoftwareUtil.getRunnableList(process, modes);
        for (Runnable runnable : runnables) {
            result = result.add(RuntimeUtil.getExecutionTimeForRunnable(runnable, processingUnit, modes, executionCase));
        }
        return result;
    }

    public static Time getExecutionTimeForRunnable(Runnable runnable, ProcessingUnit processingUnit, EMap<ModeLabel, String> modes, TimeType executionCase) {
        Time result = FactoryUtil.createTime();
        List<Ticks> tickList = SoftwareUtil.getTicks(runnable, modes);
        for (Ticks tick : tickList) {
            result = result.add(RuntimeUtil.getExecutionTimeForTicks(tick, processingUnit, executionCase));
        }
        List<ExecutionNeed> executionNeedList = SoftwareUtil.getExecutionNeeds(runnable, modes);
        if (!executionNeedList.isEmpty()) {
            for (ExecutionNeed need : executionNeedList) {
                result = result.add(RuntimeUtil.getExecutionTimeForExecutionNeeds(need, processingUnit, executionCase));
            }
        }
        return result;
    }

    public static Time getExecutionTimeForTicks(Ticks ticks, ProcessingUnit processingUnit, TimeType executionCase) {
        Time result = FactoryUtil.createTime();
        if (ticks.getExtended().get((Object)processingUnit.getDefinition()) != null) {
            IDiscreteValueDeviation deviation = (IDiscreteValueDeviation)ticks.getExtended().get((Object)processingUnit.getDefinition());
            result = RuntimeUtil.getExecutionTimeForTicksDeviation(deviation, processingUnit, executionCase);
        } else {
            result = RuntimeUtil.getExecutionTimeForTicksDeviation(ticks.getDefault(), processingUnit, executionCase);
        }
        return result;
    }

    public static Time getExecutionTimeForTicksDeviation(IDiscreteValueDeviation deviation, ProcessingUnit processingUnit, TimeType executionCase) {
        double ticks = 0.0;
        switch (executionCase) {
            case BCET: {
                ticks = deviation.getLowerBound().doubleValue();
                break;
            }
            case ACET: {
                ticks = deviation.getAverage();
                break;
            }
            case WCET: {
                ticks = deviation.getUpperBound().doubleValue();
            }
        }
        Time result = RuntimeUtil.getExecutionTimeForCycles(ticks, processingUnit.getFrequencyDomain().getDefaultValue());
        return result;
    }

    public static Time getExecutionTimeForExecutionNeeds(ExecutionNeed need, ProcessingUnit processingUnit, TimeType executionCase) {
        Time result = FactoryUtil.createTime();
        HWModel hwModel = (HWModel)processingUnit.getDefinition().eContainer();
        for (Map.Entry needEntry : need.getNeeds()) {
            Set<HwFeatureCategory> hwFeatureCategory = AmaltheaIndex.getElements((Notifier)hwModel, (String)needEntry.getKey(), HwFeatureCategory.class);
            if (hwFeatureCategory.size() == 1) {
                result = RuntimeUtil.getExecutionTimeForExecutionNeedEntry((IDiscreteValueDeviation)needEntry.getValue(), hwFeatureCategory.iterator().next(), processingUnit, executionCase);
                continue;
            }
            System.out.println("Mutliple Categories with the same name: " + (String)needEntry.getKey());
        }
        return result;
    }

    public static Time getExecutionTimeForExecutionNeedEntry(IDiscreteValueDeviation deviation, HwFeatureCategory hwFeatureCategory, ProcessingUnit processingUnit, TimeType executionCase) {
        double ticks = 0.0;
        switch (executionCase) {
            case BCET: {
                ticks = deviation.getLowerBound().doubleValue();
                break;
            }
            case ACET: {
                ticks = deviation.getAverage();
                break;
            }
            case WCET: {
                ticks = deviation.getUpperBound().doubleValue();
            }
        }
        double scaleFactor = 0.0;
        for (HwFeature feature : processingUnit.getDefinition().getFeatures()) {
            if (!feature.getContainingCategory().equals(hwFeatureCategory)) continue;
            scaleFactor = feature.getValue();
        }
        Time result = RuntimeUtil.getExecutionTimeForCycles(ticks *= scaleFactor, processingUnit.getFrequencyDomain().getDefaultValue());
        return result;
    }

    public static Time getExecutionTimeForCycles(double ticks, Frequency frequency) {
        if (frequency == null) {
            return null;
        }
        double cyclesPerSecond = AmaltheaServices.convertToHertz(frequency).doubleValue();
        double factor = 1.0 / cyclesPerSecond;
        Time oneSecond = FactoryUtil.createTime(1L, TimeUnit.S);
        Time t1 = oneSecond.multiply(ticks);
        Time result = t1.multiply(factor);
        return result.adjustUnit();
    }

    public static void setRuntimeOfRunnable(Runnable runnable, ExecutionNeed need, EMap<ModeLabel, String> modes) {
        RuntimeUtil.clearRuntimeOfRunnable(runnable, modes);
        RuntimeUtil.addRuntimeToRunnable(runnable, need);
    }

    public static void setRuntimeOfRunnable(Runnable runnable, Ticks ticks, EMap<ModeLabel, String> modes) {
        RuntimeUtil.clearRuntimeOfRunnable(runnable, modes);
        RuntimeUtil.addRuntimeToRunnable(runnable, ticks);
    }

    public static void addRuntimeToRunnable(Runnable runnable, ExecutionNeed need) {
        runnable.getRunnableItems().add((Object)need);
    }

    public static void addRuntimeToRunnable(Runnable runnable, Ticks ticks) {
        runnable.getRunnableItems().add((Object)ticks);
    }

    public static void clearRuntimeOfModel(Amalthea model, EMap<ModeLabel, String> modes) {
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process process : processes) {
            RuntimeUtil.clearRuntimeOfProcess(process, modes);
        }
    }

    public static void clearRuntimeOfProcess(Process process, EMap<ModeLabel, String> modes) {
        List<ExecutionNeed> executionNeeds = SoftwareUtil.getExecutionNeeds(process, modes);
        AmaltheaIndex.deleteAll(executionNeeds);
        List<Ticks> ticks = SoftwareUtil.getTicks(process, modes);
        AmaltheaIndex.deleteAll(ticks);
    }

    public static void clearRuntimeOfRunnable(Runnable runnable, EMap<ModeLabel, String> modes) {
        List<ExecutionNeed> executionNeeds = SoftwareUtil.getExecutionNeeds(runnable, modes);
        AmaltheaIndex.deleteAll(executionNeeds);
        List<Ticks> ticks = SoftwareUtil.getTicks(runnable, modes);
        AmaltheaIndex.deleteAll(ticks);
    }

    public static Runnable addRuntimeToProcessAsNewRunnable(Process process, ExecutionNeed need, String runnableName, PositionType positon) {
        Runnable run = AmaltheaFactory.eINSTANCE.createRunnable();
        run.setName(runnableName);
        run.getRunnableItems().add((Object)need);
        RunnableCall call = AmaltheaFactory.eINSTANCE.createRunnableCall();
        call.setRunnable(run);
        if (positon.equals((Object)PositionType.FIRST)) {
            process.getActivityGraph().getItems().add(0, (Object)call);
        } else {
            process.getActivityGraph().getItems().add((Object)call);
        }
        return run;
    }

    public static Runnable addRuntimeToProcessAsNewRunnable(Process process, Ticks ticks, String runnableName, PositionType positon) {
        Runnable run = AmaltheaFactory.eINSTANCE.createRunnable();
        run.setName(runnableName);
        run.getRunnableItems().add((Object)ticks);
        RunnableCall call = AmaltheaFactory.eINSTANCE.createRunnableCall();
        call.setRunnable(run);
        if (positon.equals((Object)PositionType.FIRST)) {
            process.getActivityGraph().getItems().add(0, (Object)call);
        } else {
            process.getActivityGraph().getItems().add((Object)call);
        }
        return run;
    }

    public static double getProcUnitUtilization(ProcessingUnit procUnit, Amalthea model, TimeType tt, List<HwFeature> hwFeatures, EMap<ModeLabel, String> modes) {
        double utilization = 0.0;
        for (Process proc : DeploymentUtil.getProcessesMappedToCore(procUnit, model)) {
            utilization += RuntimeUtil.getProcessUtilization(proc, procUnit, model, tt, hwFeatures, modes);
        }
        return utilization;
    }

    public static Map<ProcessingUnit, Double> getProcessUtilization(Process process, Amalthea model, TimeType tt, List<HwFeature> hwFeatures, EMap<ModeLabel, String> modes) {
        HashMap<ProcessingUnit, Double> utilizations = new HashMap<ProcessingUnit, Double>();
        Set<ProcessingUnit> procUnits = DeploymentUtil.getAssignedCoreForProcess(process, model);
        for (ProcessingUnit procUnit : procUnits) {
            double utilization = RuntimeUtil.getProcessUtilization(process, procUnit, model, tt, hwFeatures, modes);
            utilizations.put(procUnit, utilization);
        }
        return utilizations;
    }

    public static double getProcessUtilization(Process process, ProcessingUnit procUnit, Amalthea model, TimeType tt, List<HwFeature> hwFeatures, EMap<ModeLabel, String> modes) {
        double utilization = 0.0;
        List<Time> periods = RuntimeUtil.getPeriodsOfProcess(process, tt, modes);
        Time time = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        if (time.getValue().compareTo(BigInteger.valueOf(0L)) < 0) {
            System.err.println("execTime " + time);
        }
        for (Time period : periods) {
            if (period == null || period.getValue().intValue() == 0) continue;
            utilization += time.divide(period);
        }
        return utilization;
    }

    public static double getProcessUtilization(Process process, Time period, TimeType tt, EMap<ModeLabel, String> modes) {
        Time time = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        return time.divide(period);
    }

    public static Map<Process, Double> getCumulativeProcessUtilizations(Amalthea model, TimeType tt, List<HwFeature> hwFeatures, EMap<ModeLabel, String> modes) {
        HashMap<Process, Double> utilizations = new HashMap<Process, Double>();
        ArrayList<Process> procList = new ArrayList<Process>();
        procList.addAll((Collection<Process>)model.getSwModel().getTasks());
        procList.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process proc : procList) {
            Map<ProcessingUnit, Double> utilizationMap = RuntimeUtil.getProcessUtilization(proc, model, tt, hwFeatures, modes);
            double util = 0.0;
            for (Double value : utilizationMap.values()) {
                util += value.doubleValue();
            }
            utilizations.put(proc, util);
        }
        return utilizations;
    }

    public static Map<Process, List<Time>> getPeriodsOfAllProcesses(Amalthea model, TimeType tt, EMap<ModeLabel, String> modes) {
        HashMap<Process, List<Time>> result = new HashMap<Process, List<Time>>();
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process process : processes) {
            List<Time> periods = RuntimeUtil.getPeriodsOfProcess(process, tt, modes);
            result.put(process, periods);
        }
        return result;
    }

    public static List<Time> getPeriodsOfProcess(Process process, TimeType tt, EMap<ModeLabel, String> modes) {
        ArrayList<Time> result = new ArrayList<Time>();
        for (Stimulus stimulus : process.getStimuli()) {
            if (stimulus instanceof PeriodicStimulus) {
                PeriodicStimulus p = (PeriodicStimulus)stimulus;
                result.add(p.getRecurrence());
                continue;
            }
            if (stimulus instanceof ArrivalCurveStimulus) {
                switch (tt) {
                    case ACET: {
                        break;
                    }
                    case BCET: {
                        break;
                    }
                    case WCET: {
                        break;
                    }
                }
                continue;
            }
            if (stimulus instanceof CustomStimulus) {
                switch (tt) {
                    case ACET: {
                        break;
                    }
                    case BCET: {
                        break;
                    }
                    case WCET: {
                        break;
                    }
                }
                continue;
            }
            if (stimulus instanceof EventStimulus) {
                switch (tt) {
                    case ACET: {
                        break;
                    }
                    case BCET: {
                        break;
                    }
                    case WCET: {
                        break;
                    }
                }
                continue;
            }
            if (stimulus instanceof InterProcessStimulus) {
                Map<Process, Long> triggeringProcesses;
                InterProcessStimulus ip = (InterProcessStimulus)stimulus;
                long ipPrescaler = 1L;
                if (ip.getCounter() != null) {
                    ipPrescaler = ip.getCounter().getPrescaler();
                }
                if ((triggeringProcesses = RuntimeUtil.getTriggeringProcesses(ip, modes)).containsKey(process)) {
                    triggeringProcesses.remove(process);
                }
                for (Process triggeringProcess : triggeringProcesses.keySet()) {
                    List<Time> periods = RuntimeUtil.getPeriodsOfProcess(triggeringProcess, tt, modes);
                    for (Time t : periods) {
                        long ipaPrescaler = triggeringProcesses.get(triggeringProcess);
                        result.add(t.multiply(ipaPrescaler * ipPrescaler));
                    }
                }
                continue;
            }
            if (stimulus instanceof VariableRateStimulus) {
                VariableRateStimulus cfr_ignored_0 = (VariableRateStimulus)stimulus;
                Object time = null;
                switch (tt) {
                    case ACET: {
                        break;
                    }
                }
                if (time == null) continue;
                result.add((Time)time);
                continue;
            }
            if (stimulus instanceof SingleStimulus) {
                switch (tt) {
                    case ACET: {
                        break;
                    }
                    case BCET: {
                        break;
                    }
                    case WCET: {
                        break;
                    }
                }
                continue;
            }
            if (stimulus instanceof RelativePeriodicStimulus) {
                RelativePeriodicStimulus rp = (RelativePeriodicStimulus)stimulus;
                Time time = null;
                switch (tt) {
                    case ACET: {
                        if (rp.getNextOccurrence() == null) break;
                        time = rp.getNextOccurrence().getAverage();
                        break;
                    }
                    case BCET: {
                        if (rp.getNextOccurrence() == null) break;
                        time = rp.getNextOccurrence().getUpperBound();
                        break;
                    }
                    case WCET: {
                        if (rp.getNextOccurrence() == null) break;
                        time = rp.getNextOccurrence().getLowerBound();
                        break;
                    }
                }
                if (time == null) continue;
                result.add(time);
                continue;
            }
            if (!(stimulus instanceof PeriodicSyntheticStimulus)) continue;
            switch (tt) {
                case ACET: {
                    break;
                }
                case BCET: {
                    break;
                }
                case WCET: {
                    break;
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    public static Map<Process, Long> getTriggeringProcesses(InterProcessStimulus ip, EMap<ModeLabel, String> modes) {
        HashMap<Process, Long> result = new HashMap<Process, Long>();
        for (InterProcessTrigger interProcessTrigger : ip.getExplicitTriggers()) {
            Process parentProcess = AmaltheaServices.getContainerOfType(interProcessTrigger, Process.class);
            if (interProcessTrigger.getCounter() != null) {
                result.put(parentProcess, interProcessTrigger.getCounter().getPrescaler());
                continue;
            }
            result.put(parentProcess, 1L);
        }
        return result;
    }

    public static Map<Stimulus, Long> getTriggeredStimuli(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Stimulus, Long> stimuliMap = new HashMap<Stimulus, Long>();
        EList<InterProcessTrigger> interProcessTriggers = SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, InterProcessTrigger.class);
        interProcessTriggers.forEach(ipa -> {
            if (ipa.getCounter() != null) {
                stimuliMap.put(ipa.getStimulus(), ipa.getCounter().getPrescaler());
            } else {
                stimuliMap.put(ipa.getStimulus(), 1L);
            }
        });
        return stimuliMap;
    }

    public static Map<Process, List<Time>> getProcessesWithRelativePeriodicStimulus(Amalthea model, TimeType tt) {
        HashSet<Process> processes = new HashSet<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        Map<Process, List<Time>> result = processes.stream().collect(Collectors.toMap(p -> p, p -> p.getStimuli().stream().filter(s -> s instanceof RelativePeriodicStimulus).map(s -> RuntimeUtil.getActivationTimeFromDeviation(((RelativePeriodicStimulus)s).getNextOccurrence(), tt)).collect(Collectors.toList())));
        return result;
    }

    private static Time getActivationTimeFromDeviation(ITimeDeviation deviation, TimeType tt) {
        switch (tt) {
            case ACET: {
                return deviation.getAverage();
            }
            case BCET: {
                return deviation.getUpperBound();
            }
            case WCET: {
                return deviation.getLowerBound();
            }
        }
        return null;
    }

    public static Map<Process, List<ITimeDeviation>> getProcessesWithRelativePeriodicStimulus(Amalthea model) {
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        Map<Process, List<ITimeDeviation>> result = processes.stream().filter(p -> p.getStimuli().stream().filter(s -> s instanceof RelativePeriodicStimulus).collect(Collectors.toList()).size() > 0).collect(Collectors.toMap(p -> p, p -> p.getStimuli().stream().filter(s -> s instanceof RelativePeriodicStimulus).map(s -> ((RelativePeriodicStimulus)s).getNextOccurrence()).collect(Collectors.toList())));
        return result;
    }

    public static Map<Process, Map<Stimulus, Long>> getPlainTriggersForModel(Amalthea model, Function<Stimulus, Boolean> filter) {
        HashMap<Process, Map<Stimulus, Long>> map = new HashMap<Process, Map<Stimulus, Long>>();
        ArrayList<Process> processes = new ArrayList<Process>();
        SWModel swModel = ModelUtil.getOrCreateSwModel(model);
        processes.addAll((Collection<Process>)swModel.getTasks());
        processes.addAll((Collection<Process>)swModel.getIsrs());
        for (Process p : processes) {
            Map<Stimulus, Long> plainTriggerForProcess = RuntimeUtil.getPlainTriggerForProcess(p, 1L, filter);
            if (plainTriggerForProcess == null || plainTriggerForProcess.isEmpty()) continue;
            map.put(p, plainTriggerForProcess);
        }
        return map;
    }

    public static Map<Stimulus, Long> getPlainTriggerForProcess(Process process, long depthCounter, Function<Stimulus, Boolean> filter) {
        HashMap<Stimulus, Long> map = new HashMap<Stimulus, Long>();
        for (Stimulus stimulus : process.getStimuli()) {
            Stimulus p;
            if (filter != null && !filter.apply(stimulus).booleanValue()) continue;
            if (stimulus instanceof PeriodicStimulus) {
                p = (PeriodicStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof ArrivalCurveStimulus) {
                p = (ArrivalCurveStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof CustomStimulus) {
                p = (CustomStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof EventStimulus) {
                p = (EventStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof InterProcessStimulus) {
                InterProcessStimulus ip = (InterProcessStimulus)stimulus;
                long ipPrescaler = 1L;
                if (ip.getCounter() != null) {
                    ipPrescaler = ip.getCounter().getPrescaler();
                }
                Map<Process, Long> triggeringProcesses = RuntimeUtil.getTriggeringProcesses(ip, null);
                for (Process triggeringProcess : triggeringProcesses.keySet()) {
                    if (triggeringProcess.equals(process)) continue;
                    long ipaPrescaler = triggeringProcesses.get(triggeringProcess);
                    Map<Stimulus, Long> plainTriggerForProcess = RuntimeUtil.getPlainTriggerForProcess(triggeringProcess, depthCounter * ipaPrescaler * ipPrescaler, filter);
                    map.putAll(plainTriggerForProcess);
                }
                continue;
            }
            if (stimulus instanceof VariableRateStimulus) {
                p = (VariableRateStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof SingleStimulus) {
                p = (SingleStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof RelativePeriodicStimulus) {
                RelativePeriodicStimulus s = (RelativePeriodicStimulus)stimulus;
                map.put(s, depthCounter);
                continue;
            }
            if (!(stimulus instanceof PeriodicSyntheticStimulus)) continue;
            p = (PeriodicSyntheticStimulus)stimulus;
            map.put(p, depthCounter);
        }
        return map;
    }

    public static enum AccessDirection {
        READ,
        WRITE;

    }

    public static enum PositionType {
        FIRST,
        LAST;

    }

    public static enum TimeType {
        BCET,
        ACET,
        WCET;

    }
}

